% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_model_comparison}
\alias{export_model_comparison}
\title{Export model comparison to Excel}
\usage{
export_model_comparison(
  results_new,
  results_base,
  path = file.path(tempdir(), "model_comparison.xlsx"),
  verbose = FALSE
)
}
\arguments{
\item{results_new}{List. Results from new model.}

\item{results_base}{List. Results from base model.}

\item{path}{Character. Output file path. Default "model_comparison.xlsx".}

\item{verbose}{Logical. Print progress messages. Default FALSE.}
}
\value{
TRUE invisibly on success.
}
\description{
Creates an Excel workbook with model comparison results,
parameter summaries, and fit information.
}
\details{
Creates three worksheets:
\itemize{
  \item loo_comparison: PSIS-LOO comparison table
  \item param_summary: Sector-specific parameter estimates
  \item fit_info: Model configuration and diagnostics
}
}
\examples{
\donttest{
if (requireNamespace("openxlsx", quietly = TRUE) &&
    requireNamespace("loo", quietly = TRUE)) {
  
  # 1. Create mock results objects
  # Mock Model New
  res_new <- list(
    factor_ou = list(
      kappa_s = c(0.5, 0.6), a3_s = c(-0.1, -0.2), beta0_s = c(1, 2),
      gamma = 0.05, model = "TestModel", beta1 = 0.3, nu = 4,
      factor_ou_info = list(T_train = 50, com_in_mean = TRUE)
    ),
    diagnostics = list(
      divergences = 0,
      # Mock LOO object
      loo = list(
         estimates = matrix(c(-100, 2), 1, 2, dimnames=list("elpd_loo", c("Estimate","SE"))),
         pointwise = matrix(rep(-2, 50), ncol=1)
      )
    )
  )
  class(res_new$diagnostics$loo) <- c("psis_loo", "loo")
  
  # Mock Model Base
  res_base <- list(
    diagnostics = list(
      loo = list(
         estimates = matrix(c(-110, 2), 1, 2, dimnames=list("elpd_loo", c("Estimate","SE"))),
         pointwise = matrix(rep(-2.2, 50), ncol=1)
      )
    )
  )
  class(res_base$diagnostics$loo) <- c("psis_loo", "loo")

  # 2. Define a safe temporary path
  out_path <- file.path(tempdir(), "comparison.xlsx")
  
  # 3. Run export (This writes to tempdir, allowed by CRAN)
  try({
    export_model_comparison(res_new, res_base, path = out_path)
    # unlink(out_path) # Cleanup
  })
}
}

}
