% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_predictions.R
\name{sample_prediction}
\alias{sample_prediction}
\title{Get a draw of only the predicted elements of the nowcast vector}
\usage{
sample_prediction(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params,
  uncertainty_sampler = sample_nb,
  ref_time_aggregator = identity,
  delay_aggregator = function(x) rowSums(x, na.rm = TRUE)
)
}
\arguments{
\item{point_nowcast_matrix}{Matrix of point nowcast predictions and
observations, with rows representing the reference times and columns
representing the delays.}

\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{uncertainty_params}{Vector of uncertainty parameters ordered from
horizon 1 to the maximum horizon. Note that these will be reversed
internally to match the ordering of the \code{point_nowcast_matrix} (where
a horizon of 1 is the last entry).}

\item{uncertainty_sampler}{Function that ingests a vector or matrix of
predictions and a vector of uncertainty parameters and generates draws
from the observation model. Default is \code{sample_nb} which expects
arguments \code{pred} for the vector of predictions and uncertainty parameters
for the corresponding vector of uncertainty parameters, and draws from a
negative binomial for each element of the vector.}

\item{ref_time_aggregator}{Function that operates along the rows (reference
times) of the retrospective point nowcast matrix before it has been
aggregated across columns (delays). Default is \code{identity}
which does not aggregate across reference times.}

\item{delay_aggregator}{Function that operates along the columns (delays)
of the retrospective point nowcast matrix after it has been aggregated
across reference times. Default is \code{function(x) rowSums(x, na.rm = TRUE)}.}
}
\value{
Matrix of predicted draws at each reference date, for all reference
dates in the input \code{point_nowcast_matrix} (or fewer if using
\code{ref_time_aggregator}).
}
\description{
Get a draw of only the predicted elements of the nowcast vector
}
\examples{
# Generate point nowcast and uncertainty params from example data
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 5) |>
  tail(n = 10)
point_nowcast_matrix <- estimate_and_apply_delay(rep_tri, n = 10)
reporting_triangle <- apply_reporting_structure(rep_tri)
uncertainty_params <- estimate_uncertainty_retro(
  rep_tri,
  n_history_delay = 8,
  n_retrospective_nowcasts = 2
)
nowcast_pred_draw <- sample_prediction(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params
)
nowcast_pred_draw

# Get draws on the rolling sum
if (requireNamespace("zoo", quietly = TRUE)) {
  nowcast_pred_draw_agg <- sample_prediction(
    point_nowcast_matrix,
    reporting_triangle,
    uncertainty_params,
    ref_time_aggregator = function(x) zoo::rollsum(x, k = 2, align = "right")
  )
  nowcast_pred_draw_agg
}
}
\seealso{
Probabilistic nowcast generation functions
\code{\link{combine_obs_with_pred}()},
\code{\link{sample_nb}()},
\code{\link{sample_nowcast}()},
\code{\link{sample_nowcasts}()},
\code{\link{sample_predictions}()}
}
\concept{generate_probabilistic_nowcasts}
