% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{.validate_strata_cols}
\alias{.validate_strata_cols}
\title{Validate each of the strata columns passed to baselinenowcast}
\usage{
.validate_strata_cols(strata_cols, data)
}
\arguments{
\item{strata_cols}{Vector of character strings indicating the names of the
columns in \code{data} that determine how to stratify the data for nowcasting.
The unique combinations of the entries in the \code{strata_cols} denote the
unit of a single nowcast. Within a strata, there can be no repeated
unique combinations of reference dates and report dates. Default is \code{NULL}
which assumes that the data.frame being passed in represents a single
strata (only one nowcast will be produced). All columns that are not
part of the \code{strata_cols} will be removed.}

\item{data}{Data.frame in a long tidy format with counts by reference date
and report date for one or more strata. Must contain the following
columns:
- \code{reference_date}: Column of type \code{Date} containing the dates
of the primary event occurrence.
\itemize{
\item \code{report_date}: Column of type \code{Date} containing the dates of
report of the primary event.
\item \code{count}: Column of numeric or integer indicating the new confirmed
counts pertaining to that reference and report date.
Additional columns indicating the columns which set the unit of a single
can be included. The user can specify these columns with the
\code{strata_cols} argument, otherwise it will be assumed that the \code{data}
contains only data for a single strata.
}}
}
\description{
Validate each of the strata columns passed to baselinenowcast
}
\keyword{internal}
