% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleTree.R
\name{plotSingleTree}
\alias{plotSingleTree}
\title{plotSingleTree}
\usage{
plotSingleTree(trees, iter = 1, treeNo = 1, plotType = "icicle")
}
\arguments{
\item{trees}{A data frame created by \code{extractTreeData} function}

\item{iter}{The MCMC iteration or chain to plot.}

\item{treeNo}{The tree number to plot.}

\item{plotType}{What type of plot to display. either dendrogram or icicle.}
}
\value{
A plot of an individual tree
}
\description{
Plots individual trees.
}
\examples{
if (requireNamespace("dbarts", quietly = TRUE)) {
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6],
   df[, 1],
   ntree = 5,
   keeptrees = TRUE,
   nskip = 10,
   ndpost = 10
 )
 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 plotSingleTree(trees = trees_data, iter = 1, treeNo = 1)
}
}
