% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{combineDummy}
\alias{combineDummy}
\title{Update Dummy Variable Names}
\usage{
combineDummy(trees)
}
\arguments{
\item{trees}{A list containing at least two components: `data` and `structure`.
`data` should be a dataframe, and `structure` a dataframe that includes a `var` column.}
}
\value{
The modified `trees` list with updated `var` column entries in `trees$structure`.
}
\description{
This function updates the `var` column in the `structure` component of the `trees` list,
replacing dummy variable names derived from factor variables with their original factor variable names.
}
\details{
The function first identifies factor variables in `trees$data`, then checks each entry
in `trees$structure$var` for matches with these factor variables. If a match is found, indicating
a dummy variable, the entry is replaced with the original factor variable name.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
# Load the dbarts package to access the bart function
 library(dbarts)
 # Create Simple dbarts Model with Dummies
 set.seed(1701)
 dbartModel <- bart(iris[2:5], iris[,1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)
 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = iris)
 combined_trees <- combineDummy(trees = trees_data)
}

}
