% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{augment.bage_mod}
\alias{augment.bage_mod}
\title{Extract Data and Modeled Values}
\usage{
\method{augment}{bage_mod}(x, rows = NULL, quiet = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{"bage_mod"}, typically
created with \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
or \code{\link[=mod_norm]{mod_norm()}}.}

\item{rows}{Results are returned only for
these rows of \code{data}. A logical vector,
an index vector, or a logical expression
evaluated within \code{data}. Optional}

\item{quiet}{Whether to suppress messages.
Default is \code{FALSE}.}

\item{...}{Unused. Included for generic consistency only.}
}
\value{
A \link[tibble:tibble-package]{tibble}, with the original
data plus one or more of the following columns:
\itemize{
\item \verb{.<outcome>} Corrected or extended version of
the outcome variable, in applications where the
outcome variable has missing values, or a data model
is being used.
\item \code{.observed} 'Direct' estimates of rates or
probabilities, ie counts divided by exposure or size
(in Poisson and binomial models.)
\item \code{.fitted} Draws of rates, probabilities,
or means.
\item \code{.expected} Draws of expected values for
rates or probabilities (in Poisson
that include exposure, or in binomial models.)
}

Uncertain quantities are represented using
\link[rvec:rvec]{rvecs}.
}
\description{
Extract data and rates, probabilities, or means
from a model object.
The return value consists of the original
data and one or more columns of modeled values.
}
\details{
The \code{rows} argument can be used to
obtain results for a subset within \code{data}.
This is faster, and uses less memory, than
generating results for the whole dataset
and then subsetting.
}
\section{Fitted vs unfitted models}{


\code{augment()} is typically called on a \link[=fit]{fitted}
model. In this case, the modeled values are
draws from the joint posterior distribution for rates,
probabilities, or means.

\code{augment()} can, however, be called on an
unfitted model. In this case, the modeled values
are draws from the joint prior distribution.
In other words, the modeled values are informed by
model priors, and by values for \code{exposure}, \code{size}, or \code{weights},
but not by observed outcomes.
}

\section{Imputed values for outcome variable}{


\code{augment()} automatically imputes any missing
values for the outcome variable. If outcome variable
\code{var} has one or more \code{NA}s, then \code{augment}
creates a variable \code{.var}
holding original and imputed values.
}

\section{Data model for outcome variable}{


If the overall model includes a data model
for the outcome variable \code{var},
then \code{augment()} creates a new variable \code{.var} containing
estimates of the true value for the outcome.
}

\examples{
set.seed(0)

## specify model
mod <- mod_pois(divorces ~ age + sex + time,
                data = nzl_divorces,
                exposure = population) |>
  set_n_draw(n_draw = 100) ## smaller sample, so 'augment' faster

## fit model
mod <- mod |>
  fit()

## draw from the posterior distribution
mod |>
  augment()

## results for females only
mod |>
  augment(rows = sex == "Female")

## insert a missing value into outcome variable
divorces_missing <- nzl_divorces
divorces_missing$divorces[1] <- NA

## fitting model and calling 'augument'A
## creates a new variable called '.divorces'
## holding observed and imputed values
mod_pois(divorces ~ age + sex + time,
         data = divorces_missing,
         exposure = population) |>
  fit() |>
  augment()

## specifying a data model for the
## original data also leads to a new
## variable called '.divorces'
mod_pois(divorces ~ age + sex + time,
         data = nzl_divorces,
         exposure = population) |>
  set_datamod_outcome_rr3() |>
  fit() |>
  augment()
}
\seealso{
\itemize{
\item \code{\link[=components]{components()}} Extract values for hyper-parameters
\item \code{\link[=dispersion]{dispersion()}} Extract values for dispersion
\item \code{\link[=tidy]{tidy()}} Short summary of a model
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=is_fitted]{is_fitted()}} See if a model has been fitted
\item \code{\link[=unfit]{unfit()}} Reset a model
\item \link{datamods} Overview of data models implemented in \strong{bage}
}
}
