% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_functions.R
\name{pca_analysis}
\alias{pca_analysis}
\title{Principal Component Analysis}
\usage{
pca_analysis(data, scale = TRUE, ncp = 5, plot = TRUE, verbose = TRUE)
}
\arguments{
\item{data}{Data frame with numeric variables}

\item{scale}{Logical, whether to scale variables (default TRUE)}

\item{ncp}{Number of components to retain (default 5)}

\item{plot}{Logical, whether to generate plots}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
PCA results with eigenvalues, loadings, and scores
}
\description{
Performs PCA with visualization suitable for agricultural research data.
Includes scree plot, biplot, and variable contributions.
}
\examples{
data <- data.frame(
  yield = rnorm(30, 1200, 200),
  wue = rnorm(30, 4.5, 0.5),
  protein = rnorm(30, 22, 2),
  biomass = rnorm(30, 3500, 500)
)
pca_analysis(data)

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
