% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_split_plot.R
\name{anova_spd_c_main_ab_sub}
\alias{anova_spd_c_main_ab_sub}
\title{Split Plot Design with C in Main Plot, AB in Sub-Plot}
\usage{
anova_spd_c_main_ab_sub(
  data,
  response,
  main_plot,
  sub_factor1,
  sub_factor2,
  replication,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{main_plot}{Main plot factor (C)}

\item{sub_factor1}{First factor in sub-plot (A)}

\item{sub_factor2}{Second factor in sub-plot (B)}

\item{replication}{Name of replication factor}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table and means
}
\description{
Performs ANOVA for Split Plot Design where main plot contains single factor C 
and sub-plot contains factorial combination of AB.
}
\examples{
data <- data.frame(
  rep = rep(1:3, each = 24),
  irrigation = rep(rep(c("I1", "I2", "I3"), each = 8), 3),
  variety = rep(rep(c("V1", "V2"), each = 4), 9),
  nitrogen = rep(c("N1", "N2", "N3", "N4"), 18),
  yield = rnorm(72, 1200, 150)
)
anova_spd_c_main_ab_sub(data, response = "yield",
                         main_plot = "irrigation",
                         sub_factor1 = "variety", sub_factor2 = "nitrogen",
                         replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
