% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc_helpers.R
\name{anova_factorial}
\alias{anova_factorial}
\title{Factorial ANOVA (Two-Factor)}
\usage{
anova_factorial(
  data,
  response,
  factor1,
  factor2,
  replication = NULL,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{response}{Name of the response variable}

\item{factor1}{Name of first factor (A)}

\item{factor2}{Name of second factor (B)}

\item{replication}{Name of replication factor (optional)}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results
}
\description{
Performs two-factor factorial ANOVA with interaction analysis.
}
\examples{
data <- expand.grid(
  rep = 1:4,
  nitrogen = c("N0", "N40", "N80", "N120"),
  phosphorus = c("P0", "P30", "P60")
)
data$yield <- rnorm(nrow(data), 1200, 150)

anova_factorial(data, response = "yield", 
                factor1 = "nitrogen", factor2 = "phosphorus",
                replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
