% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-paginate-req.R
\name{arc_paginate_req}
\alias{arc_paginate_req}
\title{Paginate ArcGIS Requests}
\usage{
arc_paginate_req(req, page_size = 10, max_pages = Inf, .progress = TRUE)
}
\arguments{
\item{req}{an \code{httr2_request} ideally created with \code{arc_base_req}}

\item{page_size}{a scalar integer between 1 and 100 indicating the number of responses per page.}

\item{max_pages}{the maximum number of pages to fetch. By default fetches all pages.}

\item{.progress}{default \code{TRUE}. Whether to display a progress bar for requests.}
}
\value{
a list of \code{httr2_response}.
}
\description{
Many API endpoints provide common \href{https://developers.arcgis.com/rest/users-groups-and-items/common-parameters/#paging-properties}{pagination properties}. \code{arc_paginate_request()} automatically applies pagination to an input request.
}
\references{
\href{https://developers.arcgis.com/rest/users-groups-and-items/common-parameters/#paging-properties}{API Documentation}
}
\seealso{
\code{\link[=arc_base_req]{arc_base_req()}}
}
