% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-fns.R
\name{list_raster_fns}
\alias{list_raster_fns}
\alias{list_service_raster_fns}
\title{List Available Raster Funcitons}
\usage{
list_raster_fns(x, arg = rlang::caller_arg(x), call = rlang::caller_call())

list_service_raster_fns(
  x,
  arg = rlang::caller_arg(x),
  call = rlang::caller_call()
)
}
\arguments{
\item{x}{an \code{ImageServer}.}

\item{arg}{An argument name in the current function.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
a data.frame of the available raster functions.
}
\description{
This function returns the \code{rasterFunctionInfos} field of the \code{ImageServer}'s metadata
as a \code{data.frame}. If the field does not exist then an error is emitted.
}
\examples{
\dontrun{
# use paste to avoid cran note
furl <- paste0(
  "https://di-usfsdata.img.arcgis.com/arcgis/rest/services",
  "/FIA_BIGMAP_2018_Tree_Species_Aboveground_Biomass/ImageServer"
)

service <- arc_open(furl)
raster_fns <- list_service_raster_fns(service)
head(raster_fns)
}
}
