% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R,
%   R/SoilProfileCollection-setters.R
\docType{methods}
\name{diagnostic_hz,SoilProfileCollection-method}
\alias{diagnostic_hz,SoilProfileCollection-method}
\alias{diagnostic_hz}
\alias{diagnostic_hz<-}
\alias{diagnostic_hz<-,SoilProfileCollection-method}
\title{Get or Set Diagnostic Horizon data in a SoilProfileCollection}
\usage{
\S4method{diagnostic_hz}{SoilProfileCollection}(object)

\S4method{diagnostic_hz}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An object inheriting from \code{data.frame}}
}
\description{
Diagnostic horizons describe features of the soil relevant to taxonomic classification. A single profile may have multiple diagnostic features or horizons, each of which may be comprised of multiple horizons.
\itemize{
\item \code{diagnostic_hz()} (get method): Get diagnostic feature data from a SoilProfileCollection.
}

\itemize{
\item \verb{diagnostic_hz<-} (set method): Set diagnostic feature data for a SoilProfileCollection. The profile ID column from \code{object} (\code{idname(object)}) must be present in the replacement \code{value} object.
}
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# assign two profiles a zone related to the mollic epipedon
newdata <- data.frame(id = c("hon-1","hon-17"),
                      featkind = "fixed-depth surface sample",
                      featdept = 0,
                      featdepb = 18)

# do left join
diagnostic_hz(sp2) <- newdata

# inspect site table: newvalue TRUE only for horizons
#  with top depth equal to zero
diagnostic_hz(sp2)

}
