% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeHessian.R
\name{apollo_makeHessian}
\alias{apollo_makeHessian}
\title{Creates hessian function.}
\usage{
apollo_makeHessian(apollo_beta, apollo_fixed, apollo_logLike)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for (all) parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not 
change during estimation.}

\item{apollo_logLike}{Function to calculate the log-likelihood of the model, as created by \link{apollo_makeLogLike}
If provided, the value of the analytical gradient will be compared to the value of the
numerical gradient as calculated using apollo_logLike and the numDeriv package.
If the difference between the two is bigger than 1% for any dimension, it will be assumed
that the analytical gradient is wrong and NULL will be returned.}
}
\value{
apollo_hessian function. It receives a single argument called \code{b}, which are the _variable_ 
        parameters (i.e. must not include fixed parameters).
}
\description{
Creates hessian function from the likelihood function apollo_probabilities provided by the user. Returns NULL if 
the creation of gradient function fails.
}
\details{
Internal use only. Called by \code{apollo_estimate} before estimation.
The returned function can be single-threaded or multi-threaded based on the model options.
}
