% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{posterior-probabilities}
\alias{posterior-probabilities}
\alias{predict.aphylo_estimates}
\alias{predict_pre_order}
\alias{predict_pre_order.aphylo_estimates}
\alias{predict_pre_order.aphylo}
\alias{predict_brute_force}
\title{Posterior probabilities based on parameter estimates}
\usage{
\method{predict}{aphylo_estimates}(
  object,
  which.tree = NULL,
  ids = NULL,
  newdata = NULL,
  params = stats::coef(object),
  loo = TRUE,
  nsamples = 1L,
  centiles = c(0.025, 0.5, 0.975),
  cl = NULL,
  ...
)

predict_pre_order(x, ...)

\method{predict_pre_order}{aphylo_estimates}(
  x,
  params = stats::coef(x),
  which.tree = 1:Ntrees(x),
  ids = lapply(Ntip(x)[which.tree], seq_len),
  loo = TRUE,
  nsamples = 1L,
  centiles = c(0.025, 0.5, 0.975),
  ncores = 1L,
  cl = NULL,
  ...
)

\method{predict_pre_order}{aphylo}(x, psi, mu_d, mu_s, eta, Pi, ...)

predict_brute_force(atree, psi, mu_d, mu_s, Pi, force = FALSE)
}
\arguments{
\item{which.tree}{Integer scalar. Which tree to include in the prediction.}

\item{ids}{Integer vector. Ids (positions) of the nodes that need to be
predicted (see details.)}

\item{newdata}{(optional) An aphylo object.}

\item{params}{A numeric vector with the corresponding parameters.}

\item{loo}{Logical scalar. When \code{loo = TRUE}, predictions are preformed
similar to what a leave-one-out cross-validation scheme would be done
(see \link{predict.aphylo_estimates}).}

\item{nsamples}{Integer scalar. When greater than one, the prediction is done
using a random sample from the MCMC chain. This only works if the model was
fitted using MCMC, of course.}

\item{centiles}{Used together with \code{nsamples}, this indicates the centiles
to be computed from the distribution of outcomes.}

\item{...}{Ignored.}

\item{ncores, cl}{Passed to \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{psi}{Numeric vector of length 2. Misclasification probabilities. (see \code{\link{LogLike}}).}

\item{mu_d, mu_s}{Numeric vector of length 2. Gain/loss probabilities (see \code{\link{LogLike}}).}

\item{eta}{Numeric vector of length 2. Annotation bias probabilities (see \code{\link{LogLike}}).}

\item{Pi}{Numeric scalar. Root node probability of having the function (see \code{\link{LogLike}}).}

\item{atree, x, object}{Either a tree of class \link{aphylo} or an object of class \link{aphylo_estimates}}

\item{force}{Logical scalar. When \code{TRUE} it will try to compute the brute-force
probabilities for trees with more than 7 nodes.}
}
\value{
In the case of the \code{predict} method, a \code{P} column numeric matrix
with values between \eqn{[0,1]} (probabilities).
}
\description{
The function \code{predict_pre_order} uses a pre-order algorithm to compute the
posterior probabilities, whereas the \code{predict_brute_force} computes posterior
probabilities generating all possible cases.
}
\details{
The function \code{predict_brute_force} is only intended for testing. For predictions
after estimating the model, see \link{predict.aphylo_estimates}.

In the case of the parameter \code{loo} (leave-one-out), while making tip-level
predictions, at each leaf the algorithm will drop annotations regarding that
leaf, making its prediction using all the available information except the
one include in such leaf.

The \code{predict_brute_force} function makes the (obviously) brute force
calculation of the probabilities. It will perform
It returns a list with the following:
\itemize{
\item \code{Pr} The conditional probabilities of observing a tree given a particular state
of the leave nodes. The size is given by (2^nnodes x 2^nleaves), each entry is
read as "The probability of observing scenario i (row) given that the leaves have
state j (colum)." The scenarios are specified in the \code{row} matrix returned by the
function.
\item \code{row} Indicates the state of each node (columns) per scenario (row).
\item \code{col} Indicates the state of each leaf node (columns) per potential leaf
scenario.
}
}
\section{Prediction on specific nodes}{

The \code{ids} parameter indicates for which nodes, both internal and tips, the
predictions should be made. By default, the function will only make predictions
on the leaf nodes.

The ids follow \code{ape}'s convention, this is, \code{1:Ntips(x)}
are the leaf nodes, \code{Ntips(x) + 1L} is the root node, and everything else
are the interior nodes.

Although the prediction algorithm is fast, indicating only
a subset of the nodes could make a difference when \code{loo = TRUE} and/or
\code{nsamples > 1} (calculating a Credible/Confidence Interval.)

In the case of \code{multiAphylo}, \code{ids} should be passed as a list of length
\code{Ntrees(x)}, with each element indicating the nodes. Otherwise, ids
are passed as an integer vector.
}

\examples{
# Single tree ---------------------------------------------------------------
set.seed(123)
atree <- raphylo(10)

# Fitting the model with MLE
ans <- aphylo_mle(atree ~ psi + mu_d + mu_s + Pi)

# Prediction on leaves
predict(ans)

# Prediction on all nodes (including root and interior)
predict(ans, ids = 1:Nnode(ans, internal.only = FALSE))

# Multiple trees (multiAphylo) ----------------------------------------------
atree <- c(raphylo(10), raphylo(5))

# Fitting the model with MLE
ans <- aphylo_mle(atree ~ psi + mu_d + mu_s + Pi)

# Prediction on leaves
predict(ans)

# Predicting only interior nodes
predict(ans, ids = list(11:19, 6:9))

}
