% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmYoungModulus.R
\name{afmYoungModulus}
\alias{afmYoungModulus}
\title{afmYoungModulus}
\usage{
afmYoungModulus(
  afmdata,
  thickness = NULL,
  model = "Hertz",
  geometry = c("pyramid", "paraboloid", "cone"),
  thin_correction = FALSE,
  showfit = FALSE,
  params,
  silent = FALSE
)
}
\arguments{
\item{afmdata}{An \code{afmdata} object. It should be a valid afmdata object upon which
the Contact Point, the baseline correction and the Zero Force Point and the 
Indentation must have been calculated first (using functions 
\code{afmContactPoint()}, \code{afmBaselineCorrection()}, \code{afmZeroPointSlope()},
and \code{afmIndentation()})}

\item{thickness}{Thickness (in m) of the surface. The Force - Indentation fit will be 
done for values of the Indentation variable smaller than the thickness. If no value 
is given, it will be done for all values in the curve for which the Indentation is 
negative.}

\item{model}{Contact mechanics model to be used. Currently only Hertz's pure elastic 
model is available.}

\item{geometry}{Geometry of the tip. Currently only pyramidal (default), paraboloid, 
and conical geometries are implemented.}

\item{thin_correction}{Logical value. If TRUE a thin layer correction is performed as 
shown in Dimitriadis et al. 2002, and in Gavara and Chadwick 2012.}

\item{showfit}{Logical value. If FALSE it prints the fit model summary (via 
\code{summary.lm()}). Default value is FALSE}

\item{params}{A list containing different parameters of the model: e.g. nu (Poisson's 
ratio) or alpha (internal angle, in degrees, of the pyramidal and conical tips) or R (tip radius, 
in the paraboloid geometry)}

\item{silent}{Logical value. If TRUE suppresses the message indicating the name of the curve being processed
(useful for batch-processing large number of curves). Defaults to FALSE}
}
\value{
An \code{afmdata} class variable which will consist on the original input 
  \code{afmdata} variable plus a new list named \code{YoungModulus} with the following 
  fields:
  
  \code{YoungModulus} The Young's modulus value (in Pa).
  
  \code{fitYM} The Force vs Indentation^2 fit as an \code{lm} object.
  
  \code{fitdata} The subset of the data used in the fit.
}
\description{
This function computes the Young's Modulus of the sample from the approach
  curve using Hertz's  contact model  for a pyramidal, paraboloid or conical tip.
}
\examples{
data <- afmReadJPK("force-save-JPK-2h.txt.gz", path = path.package("afmToolkit"))
data <- afmContactPoint(data, width = 20, mul1 = 1, mul2 = 20)
data <- afmDetachPoint(data, width = 40, mul1 = 3, mul2 = 40)
data <- afmBaselineCorrection(data)
data <- afmZeroPointSlope(data, segment = "approach")
data <- afmIndentation(data)
data <- afmYoungModulus(data, thickness = 1e-8, params = list(alpha = 22),
                        silent = TRUE)
print(data$YoungModulus$YoungModulus)
}
