% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotoxal_2ngon_inner_radius.r
\name{isotoxal_2ngon_inner_radius}
\alias{isotoxal_2ngon_inner_radius}
\alias{star_inner_radius}
\title{Isotoxal \verb{2n}-gon inner radius}
\usage{
isotoxal_2ngon_inner_radius(
  n,
  outer_radius = 1,
  ...,
  alpha = NULL,
  beta_ext = NULL,
  d = NULL
)

star_inner_radius(
  n,
  outer_radius = 1,
  ...,
  alpha = NULL,
  beta_ext = NULL,
  d = NULL
)
}
\arguments{
\item{n}{The number of outer vertices.}

\item{outer_radius}{The outer radius of the isotoxal \verb{2n}-gon.}

\item{...}{Ignored.}

\item{alpha}{The interior angle of an outer vertex.  Will be coerced by \code{\link[=degrees]{degrees()}}.}

\item{beta_ext}{The exterior angle of an inner vertex.  Will be coerced by \code{\link[=degrees]{degrees()}}.}

\item{d}{The density aka winding number of the regular star polygon (outline) in which case this star is represented by \verb{|n/d|}.}
}
\value{
A numeric vector
}
\description{
\code{isotoxal_2ngon_inner_radius()} computes the inner radius
of an isotoxal \verb{2n}-gon polygon.
\code{star_inner_radius()} is an alias.
}
\details{
Isotoxal \verb{2n}-gon polygons are polygons with:
\itemize{
\item \verb{2n} vertices alternating between \code{n} "outer" vertices evenly spaced on one circle and \code{n} "inner" vertices evenly spaced on smaller circle with the same center.
\item Each edge of the polygon is of the same length.
\item The outer vertices all have the same interior angle \code{alpha} and the
inner vertices all have the same interior angle \code{beta}.
\item They are a generalization of (the outlines of) concave simple "star" polygons that also includes convex polygons with an even number of vertices.
}
}
\examples{
# |8/3| star has outer vertex internal angle 45 degrees
# and inner vertex external angle 90 degrees
isotoxal_2ngon_inner_radius(8, d = 3)
isotoxal_2ngon_inner_radius(8, alpha = 45)
isotoxal_2ngon_inner_radius(8, beta_ext = 90)
}
\seealso{
\url{https://en.wikipedia.org/wiki/Isotoxal_figure#Isotoxal_polygons} and \url{https://en.wikipedia.org/wiki/Star_polygon#Isotoxal_star_simple_polygons} for more information on isotoxal polygons.
}
