% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesopR-package.R
\docType{package}
\name{aesopR-package}
\alias{aesopR}
\alias{aesopR-package}
\title{aesopR: Text Analysis of Aesop's Fables}
\description{
\pkg{aesopR} provides a tidy text corpus of Aesop's Fables sourced
from the Library of Congress, along with analysis-ready datasets for
exploring sentiment, emotion, and linguistic patterns in moral storytelling.
}
\details{
The package is designed for teaching, research, and exploratory text analysis,
offering both raw narrative texts and tokenized data structures. It also
includes pre-joined sentiment datasets based on widely used lexicons to
support reproducible workflows without requiring interactive downloads.

Core features include:
\itemize{
  \item A curated public-domain corpus of 147 Aesop's Fables
  \item Tidy tokenized representations for NLP workflows
  \item Pre-joined sentiment datasets using established lexicons (Bing, AFINN)
}
}
\section{Datasets}{

\itemize{
  \item \link[aesopR]{aesops_fables}: Full fable texts and metadata
  \item \link[aesopR]{aesops_tokens}: Tokenized corpus for text analysis
  \item \link[aesopR]{aesops_afinn}: Tokens joined with AFINN sentiment scores
  \item \link[aesopR]{aesops_bing}: Tokens joined with Bing sentiment labels
}
}

\author{
Dave Brocker
}
