% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_crpr.R
\name{get_crpr_dataset}
\alias{get_crpr_dataset}
\title{Get CR Records Followed by PR That Lead to a Prior Error}
\usage{
get_crpr_dataset()
}
\value{
A \code{data.frame} or \code{NULL}
}
\description{
Get CR Records Followed by PR That Lead to a Prior Error
}
\details{
Some \code{{admiralonco}} functions check that in the source records CR is not
followed by PR and throw an error otherwise. The \code{get_crpr_dataset()}
function allows one to retrieve the duplicate records that lead to an error.

Note that the function always returns the dataset of duplicates from the last
error that has been thrown in the current R session. Thus, after restarting
the R sessions \code{get_crpr_dataset()} will return \code{NULL} and after a second
error has been thrown, the dataset of the first error can no longer be
accessed (unless it has been saved in a variable).
}
\examples{
library(tibble)
library(dplyr)
library(lubridate)
library(admiralonco)
library(rlang)

adrs <- tribble(
  ~USUBJID, ~ADTC,        ~AVALC,
  "1",      "2020-01-01", "PR",
  "1",      "2020-02-01", "CR",
  "1",      "2020-02-16", "NE",
  "1",      "2020-03-01", "CR",
  "2",      "2020-02-06", "PR",
  "2",      "2020-02-16", "CR",
  "2",      "2020-03-30", "PR",
) \%>\%
  mutate(
    ADT = ymd(ADTC),
    STUDYID = "XX1234"
  )

signal_crpr(adrs, order = exprs(ADT))

get_crpr_dataset()
}
\seealso{
\code{\link[=signal_crpr]{signal_crpr()}}

Utilities for Dataset Checking:
\code{\link{signal_crpr}()}
}
\author{
Stefan Bundfuss
}
\concept{utils_ds_chk}
\keyword{utils_ds_chk}
