% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs.R
\name{aclhs.vario_params}
\alias{aclhs.vario_params}
\title{Set parameters for computing a Variogram.}
\usage{
aclhs.vario_params(num_lags = 8, dir = 0, tol = 90, min_pairs = 1)
}
\arguments{
\item{num_lags}{The number of lags}

\item{dir}{The direction}

\item{tol}{The tolerance}

\item{min_pairs}{The minimum number of pairs}
}
\value{
A list of the set Variogram parameters
}
\description{
Sets specific parameters for computing Variograms within the acLHS 1D or 2D
function calls. Note that the lag value computed for Variograms will always
be the 'minimum' of the independent data (i.e., for 1D minimum time between
points and for 2D minimum distance between points).
}
\examples{
## Store the parameters into a variable
v_params <- aclhs.vario_params(num_lags=10, dir=0, tol=90, min_pairs=1)

## Access one of the the set parameters
v_params$num_lags
}
