% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs_plot.R
\name{aclhs.plot_univariate_pdf}
\alias{aclhs.plot_univariate_pdf}
\title{Plot the univariate PDF for a column of acLHS-derived samples.}
\usage{
aclhs.plot_univariate_pdf(df, aclhs_samples, col, plot_params)
}
\arguments{
\item{df}{The original data in dataframe format}

\item{aclhs_samples}{The acLHS-derived sample indices}

\item{col}{The column of data to plot}

\item{plot_params}{The plotting parameters to use}
}
\value{
No return value, called for side effects
}
\description{
Plots the univariate PDF of acLHS-sampled points over the original
univariate PDF data. The PDF can be plotted for either the dependent
or independent variable of the original data.
}
\examples{
## Get the data of interest and get the acLHS sample indices
data(ex_data_2D)
input2D <- ex_data_2D
aclhs_sam <- aclhs(df=input2D, num_samples=50, weights=c(1,1,1), iter=100)

## Set plotting parameters
p_params <- aclhs.plot_params(file_name=tempfile(fileext=".png"),
                              xlab=expression(bold("Temperature [Celsius]")),
                              ylab=expression(bold("Fn(Temperature)")))

## Create plot
aclhs.plot_univariate_pdf(df=input2D, aclhs_samples=aclhs_sam, col=3,
                          plot_params=p_params)
}
