% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs.R
\name{aclhs}
\alias{aclhs}
\title{Get subsample indices using the acLHS algorithm.}
\usage{
aclhs(
  df,
  num_samples,
  weights,
  iter = 1000,
  vario_params = aclhs.vario_params(),
  export_file = NULL
)
}
\arguments{
\item{df}{A dataframe with three columns of data}

\item{num_samples}{The number of desired subsamples}

\item{weights}{A vector of three weights for each objective function}

\item{iter}{The max number of iterations to perform to find optimized indices}

\item{vario_params}{A list of parameters to use when computing Variograms}

\item{export_file}{The name of a CSV to export subsampled rows to}
}
\value{
A numeric vector of subsample indices of the original data
}
\description{
This function extracts a desired number of subsample indices from a dataframe
using the acLHS algorithm. The function works for either 1D or 2D data, where
it is assumed the last two columns of data are the independent and dependent
variables, respectively. Determining the optimal subsamples is done using
the DEoptim package, which introduces elements of nondeterminism through
randomization. If you desire consistent results, ensure to set a seed before
running the function.
}
\examples{
## acLHS sampling example
data(ex_data_2D)
input2D <- ex_data_2D

# Set Variogram parameters
v_params <- aclhs.vario_params(num_lags=10, dir=0, tol=90, min_pairs=1)

## Set weights for each objective function, respectively
w <- c(10, 1000, 0.001)

## Run the sampling algorithm
aclhs_samples <- aclhs(df=input2D, num_samples=50, weights=w, iter=100,
                       vario_params=v_params,
                       export_file=tempfile(fileext=".csv"))

## Subsample original data
df_sampled <- input2D[aclhs_samples,]
}
