% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{QC}
\alias{QC}
\title{Perform quality control analysis for high-throughput screening data.}
\usage{
QC(countMat, negGene, posGene)
}
\arguments{
\item{countMat}{A matrix of raw count data where rows represent genes/siRNAs and columns represent readouts/conditions. The matrix should have row names corresponding to gene/siRNA identifiers.}

\item{negGene}{A data frame or matrix containing negative control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in countMat.}

\item{posGene}{A data frame or matrix containing positive control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in countMat.}
}
\value{
A list containing four diagnostic plots:
  \item{score_qc}{A jitter plot showing the distribution of raw scores across all readouts for positive and negative controls}
  \item{tSNE_QC}{A t-SNE plot showing the global separation of positive and negative control samples in 2D space}
  \item{QC_box}{Side-by-side boxplots showing the distribution of scores for positive and negative controls across all readouts}
  \item{QC_SSMD}{A density plot showing the distribution of SSMD scores across readouts, with a threshold line at SSMD=2 and the percentage of high-quality readouts displayed}
}
\description{
This function performs comprehensive quality control analysis on high-throughput screening data to evaluate experimental design and data quality. It generates multiple diagnostic plots and calculates SSMD (Strictly Standardized Mean Difference) scores to assess the separation between positive and negative controls.
}
\details{
The function performs the following quality control analyses:
\enumerate{
  \item Creates jitter plots to visualize score distributions across readouts
  \item Performs t-SNE dimensionality reduction to assess global sample separation
  \item Generates boxplots to compare score distributions between control groups
  \item Calculates SSMD scores for each readout: \eqn{\mathrm{SSMD} = (\mu_{pos} - \mu_{neg}) / \sqrt{\sigma_{pos}^2 + \sigma_{neg}^2}}
  \item Reports the percentage of readouts with \eqn{|\mathrm{SSMD}| \ge 2} (considered high quality)
}

SSMD scores \eqn{\ge 2} indicate good separation between positive and negative controls, suggesting high-quality readouts.
}
\examples{
data(countMat)
data(negGene)
data(posGene)
\donttest{QC(countMat, negGene, posGene)}

}
\references{
Laurens van der Maaten & Geoffrey Hinton: Visualizing Data using t-SNE. Journal of Machine Learning Research 2008, 9(2008):2579-2605.

Zhang XD: A pair of new statistical parameters for quality control in RNA interference high-throughput screening assays. Genomics 2007, 89:552-561.
}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{SSMD}
\keyword{ZetaSuite}
\keyword{control}
\keyword{quality}
\keyword{t-SNE}
