% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_report_sc.R
\name{generate_cat_report}
\alias{generate_cat_report}
\title{Generate a Comprehensive Analysis Report}
\usage{
generate_cat_report(
  results_cat = results_cat,
  enrichment_cat = results_cat,
  grn_object = grn_object,
  output_file = "cat_analysis_report.html",
  output_dir = tempdir(),
  template_path = NULL,
  quiet = TRUE
)
}
\arguments{
\item{results_cat}{A data frame or list containing differential expression results.}

\item{enrichment_cat}{A list with enrichment objects (e.g., BP, MF, KEGG, and optionally GSEA results).}

\item{grn_object}{An igraph object representing the gene regulatory network (e.g., from PCSF analysis).}

\item{output_file}{Character. The desired name (and optionally path) for the rendered report (default: "analysis_report.html").}

\item{output_dir}{Character. Output directory to save the report to.}

\item{template_path}{Character. Path to the R Markdown template file. If \code{NULL}, the function uses the built-in template located in \code{inst/rmd/template_report.Rmd}.}

\item{quiet}{Logical. If \code{TRUE} (default), rendering will be quiet.}
}
\value{
A character string with the path to the rendered report.
}
\description{
This function creates an integrated report that combines key analysis outputs,
}
