% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation_generic.R
\name{get_aggregated_data}
\alias{get_aggregated_data}
\title{Extract Aggregated Weekly Generic Data}
\usage{
get_aggregated_data(
  generic_data,
  date_column,
  number_column,
  start_date = NULL,
  end_date = NULL,
  unit = "day"
)
}
\arguments{
\item{generic_data}{the weekly generic data from \code{get_data()}}

\item{date_column}{date column name str}

\item{number_column}{cases count column name str}

\item{start_date}{start date string (e.g. '2022-01-01')(optional, default is NULL)}

\item{end_date}{end date string (e.g. '2022-12-31')(optional, default is NULL)}

\item{unit}{aggregation unit "day" or "week"}
}
\value{
aggregated weekly data of the generic confirmed cases data (filtered by date if any)
\describe{
\item{date}{Either day or week date}
\item{confirm}{number of confirmed cases}
}
}
\description{
\code{get_aggregated_data()} performs data transformation in the following steps:
\enumerate{
\item Group the weekly or daily data by date.
\item Aggregate the number of confirmed cases by either day or week.
\item Select only the date and confirmed cases column.
\item Filter the data by given start and end date
}

The input dataframe \code{generic_data} must have the following columns:
\itemize{
\item \verb{<date name>}: date column (e.g. as.Date('2022-01-01')).
\item \verb{<cases count name>}: Confirmed Cases Count (e.g. 1, 2, ...).
}

Note that these columns can be defined in a generic name, and inputted as
the other two function parameters for data transformation (\code{date_column},
\code{number_column})

Assume the date column is the start of the epiweek.
}
\examples{
sim_data <- simulate_data()
aggregated_data <- get_aggregated_data(
  sim_data,
  "date", "flu_a", "2024-10-16", "2024-12-31"
)
}
