% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedders.R
\name{SparseEmbedder}
\alias{SparseEmbedder}
\title{Sparse Embedder (BM25/TF-IDF)}
\description{
Generates sparse BM25 embeddings for keyword search
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{vocab}}{Vocabulary}

\item{\code{language}}{Language setting ("en" or "ml")}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SparseEmbedder-new}{\code{SparseEmbedder$new()}}
\item \href{#method-SparseEmbedder-fit}{\code{SparseEmbedder$fit()}}
\item \href{#method-SparseEmbedder-embed}{\code{SparseEmbedder$embed()}}
\item \href{#method-SparseEmbedder-query_terms}{\code{SparseEmbedder$query_terms()}}
\item \href{#method-SparseEmbedder-clone}{\code{SparseEmbedder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SparseEmbedder-new"></a>}}
\if{latex}{\out{\hypertarget{method-SparseEmbedder-new}{}}}
\subsection{Method \code{new()}}{
Create a new SparseEmbedder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseEmbedder$new(language = "en")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{language}}{Language behavior ("en" = ASCII-focused, "ml" = Unicode-aware)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SparseEmbedder-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SparseEmbedder-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the embedder on a corpus
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseEmbedder$fit(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SparseEmbedder-embed"></a>}}
\if{latex}{\out{\hypertarget{method-SparseEmbedder-embed}{}}}
\subsection{Method \code{embed()}}{
Embed texts to sparse vectors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseEmbedder$embed(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Sparse matrix of BM25 scores
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SparseEmbedder-query_terms"></a>}}
\if{latex}{\out{\hypertarget{method-SparseEmbedder-query_terms}{}}}
\subsection{Method \code{query_terms()}}{
Get term scores for a query
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseEmbedder$query_terms(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query text}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named vector of term scores
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SparseEmbedder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SparseEmbedder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseEmbedder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
