% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{VarSelImputation}
\alias{VarSelImputation}
\title{Imputation of missing values}
\usage{
VarSelImputation(obj, newdata, method = "postmean")
}
\arguments{
\item{obj}{an instance of \linkS4class{VSLCMresults}  which defines the model used for imputation.}

\item{newdata}{data.frame Dataset containing the missing values to impute.}

\item{method}{character definiting the method of imputation: "postmean" or "sampling"}
}
\description{
This function permits imputation of missing values in a dataset by using mixture model.
Two methods can be used for imputation:
\itemize{
 \item{posterior mean (method="postmean")}
 \item{sampling from the full conditionnal distribution (method="sampling")}
 }
}
\examples{
# Data loading
data("heart")

# Clustering en 2 classes
results <- VarSelCluster(heart[,-13], 2)

# Data where missing values will be imputed
newdata <- heart[1:2,-13]
newdata[1,1] <- NA
newdata[2,2] <- NA

# Imputation
VarSelImputation(results, newdata)

}
