% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.boundary.timeseries.R
\name{get.boundary.timeseries}
\alias{get.boundary.timeseries}
\title{Calculate Boundary Extended Time Series}
\usage{
get.boundary.timeseries(x, type = "TLSW")
}
\arguments{
\item{x}{The time series used to calculate the boundary extended version.}

\item{type}{The type of boundary handling used. Either \code{"TLSW"} (default) for boundary
handling as described in McGonigle, E. T., Killick, R., and Nunes, M. (2022a),
or \code{"LSW.diff"} for a periodic version of this, used for the differencing-based functions
as described in McGonigle, E. T., Killick, R., and Nunes, M. (2022b).}
}
\value{
A vector of 4 times the length of the input vector.
}
\description{
Internal function to calculate the boundary extended time series, to be used within
the \code{\link{TLSW}} function. Not recommended for general usage.
}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022a). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.

McGonigle, E. T., Killick, R., and Nunes, M. (2022b). Modelling
time-varying first and second-order structure of time series via wavelets
and differencing. \emph{Electronic Journal of Statistics}, 6(2), 4398-4448.
}
\seealso{
\code{\link{TLSW}}
}
\keyword{internal}
