% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{match,Splits,Splits-method}
\alias{match,Splits,Splits-method}
\alias{match}
\alias{\%in\%,Splits,Splits-method}
\alias{FirstMatchingSplit}
\title{Split matching}
\usage{
\S4method{match}{Splits,Splits}(x, table, nomatch = NA_integer_, incomparables = NULL)

match(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{\%in\%}{Splits,Splits}(x, table)

FirstMatchingSplit(x, table, nomatch, return = c("x", "table", "both"))
}
\arguments{
\item{x, table}{Splits objects}

\item{nomatch}{Integer value that will be used in place of \code{NA} in the case
where no match is found.}

\item{incomparables}{Ignored. (Included for consistency with generic.)}

\item{return}{Which index to return: in \code{x}, in \code{table}, or both}
}
\value{
\code{match()} returns an integer vector specifying the position in
\code{table} that matches each element in \code{x}, or \code{nomatch} if no match is found.

\code{FirstMatchingSplit()} returns an integer
(or length-2 integer if \code{return = "both"}) specifying the first split in \code{x}
to have a match in \code{table} (\code{return = "x"}),
or the index of that match (\code{return = "table"}).
\code{nomatch} (default \code{0}) is returned in the absence of a match.
}
\description{
\code{match()} returns a vector of the positions of (first) matches of splits in
its first argument in its second.
\code{\%in\%} is a more intuitive interface as a binary operator, which returns
a logical vector indicating whether there is a match or not for each
split in its left operand.
}
\examples{
splits1 <- as.Splits(BalancedTree(7))
splits2 <- as.Splits(PectinateTree(7))

match(splits1, splits2)
}
\seealso{
Corresponding base functions are documented in
\code{\link[base:match]{match()}}.

Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{Splits}},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{xor}()}
}
\concept{Splits operations}
\keyword{methods}
