% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TriangleInHull}
\alias{TriangleInHull}
\title{Does triangle overlap convex hull of points?}
\usage{
TriangleInHull(triangles, coordinates, buffer)
}
\arguments{
\item{triangles}{Three-row matrix as produced by \code{\link[=TriangleCentres]{TriangleCentres()}}.}

\item{coordinates}{A matrix with two or three rows specifying the
coordinates of points in \emph{x, y} or \emph{a, b, c} format.}

\item{buffer}{Include triangles whose centres lie within \code{buffer} triangles
widths (i.e. edge lengths) of the convex hull.}
}
\value{
\code{TriangleInHull()} returns a list with the elements:
\itemize{
\item \verb{$inside}: vector specifying whether each of a
set of triangles produced by \code{\link[=TriangleCentres]{TriangleCentres()}} overlaps the convex
hull of points specified by \code{coordinates}.
\item \verb{$hull}: Coordinates of convex hull of \code{coordinates}, after expansion
to cover overlapping triangles.
}
}
\description{
Does triangle overlap convex hull of points?
}
\examples{
set.seed(0)
nPts <- 50
a <- runif(nPts, 0.3, 0.7)
b <- 0.15 + runif(nPts, 0, 0.7 - a)
c <- 1 - a - b
coordinates <- rbind(a, b, c)

TernaryPlot(grid.lines = 5)
TernaryPoints(coordinates, pch = 3, col = 4)
triangles <- TriangleCentres(resolution = 5)
inHull <- TriangleInHull(triangles, coordinates)
polygon(inHull$hull, border = 4)
values <- rbind(triangles,
                z = ifelse(inHull$inside, "#33cc3333", "#cc333333"))
points(triangles["x", ], triangles["y", ],
       pch = ifelse(triangles["triDown", ], 6, 2),
       col = ifelse(inHull$inside, "#33cc33", "#cc3333"))
ColourTernary(values)
}
\seealso{
Other tiling functions: 
\code{\link{TriangleCentres}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tiling functions}
