% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Holdridge.R
\encoding{UTF-8}
\name{HoldridgePlot}
\alias{HoldridgePlot}
\alias{HoldridgeBelts}
\alias{HoldridgeHexagons}
\title{Plot life zones on a Holdridge plot}
\usage{
HoldridgePlot(
  atip = NULL,
  btip = NULL,
  ctip = NULL,
  alab = "Potential evapotranspiration ratio",
  blab = "Annual precipitation / mm",
  clab = "Humidity province",
  lab.offset = 0.22,
  lab.col = c("#D81B60", "#1E88E5", "#111111"),
  xlim = NULL,
  ylim = NULL,
  region = NULL,
  lab.cex = 1,
  lab.font = 0,
  tip.cex = lab.cex,
  tip.font = 2,
  tip.col = "black",
  isometric = TRUE,
  atip.rotate = NULL,
  btip.rotate = NULL,
  ctip.rotate = NULL,
  atip.pos = NULL,
  btip.pos = NULL,
  ctip.pos = NULL,
  padding = 0.16,
  col = NA,
  panel.first = NULL,
  panel.last = NULL,
  grid.lines = 8,
  grid.col = c(NA, "#1E88E5", "#D81B60"),
  grid.lty = "solid",
  grid.lwd = par("lwd"),
  grid.minor.lines = 0,
  grid.minor.col = "lightgrey",
  grid.minor.lty = "solid",
  grid.minor.lwd = par("lwd"),
  hex.border = "#888888",
  hex.col = HoldridgeHypsometricCol,
  hex.lty = "solid",
  hex.lwd = par("lwd"),
  hex.cex = 0.5,
  hex.labels = NULL,
  hex.font = NULL,
  hex.text.col = "black",
  axis.cex = 0.8,
  axis.col = c(grid.col[2], grid.col[3], NA),
  axis.font = par("font"),
  axis.labels = TRUE,
  axis.lty = "solid",
  axis.lwd = 1,
  axis.rotate = TRUE,
  axis.pos = NULL,
  axis.tick = TRUE,
  ticks.lwd = axis.lwd,
  ticks.length = 0.025,
  ticks.col = grid.col,
  ...
)

HoldridgeBelts(
  grid.col = "#004D40",
  grid.lty = "dotted",
  grid.lwd = par("lwd")
)

HoldridgeHexagons(
  border = "#004D40",
  hex.col = HoldridgeHypsometricCol,
  lty = "dotted",
  lwd = par("lwd"),
  labels = NULL,
  cex = 1,
  text.col = NULL,
  font = NULL
)
}
\arguments{
\item{atip, btip, ctip}{Character string specifying text to title corners,
proceeding clockwise from the corner specified in \code{point} (default: top).}

\item{alab, blab, clab}{Character string specifying text with which to label
the corresponding sides of the triangle.
Left or right-pointing arrows are produced by
typing \verb{\\\\U2190} or \verb{\\\\U2192}, or using \code{expression('value' \%->\% '')}.}

\item{lab.offset}{Numeric specifying distance between midpoint of axis label
and the axis. The default value is given in the 'Usage' section; a value
of \code{0} will position the axis label directly on the axis.
Increase \code{padding} if labels are being clipped.
Use a vector of length three to specify a different offset for each label.}

\item{lab.col}{Character vector specifying colours for axis labels. Use a
vector of length three to specify a different colour for each label.}

\item{xlim, ylim}{Numeric vectors of length two specifying the minimum and
maximum \emph{x} and \emph{y} limits of the plotted area, to which \code{padding} will be
added.
The default is to display the complete height or width of the plot.
Allows cropping to magnified region of the plot. (See vignette for diagram.)
May be overridden if \code{isometric = TRUE}; see documentation of
\code{isometric} parameter.}

\item{region}{(optional) Named list of length two specifying the the
\code{min}imum and \code{max}imum values of each ternary axis to be drawn
(e.g. \verb{list(min = c(40, 0, 0), max = c(100, 60, 60)});
or a set of coordinates in a format accepted by \code{\link[=TernaryPoints]{TernaryPoints()}}.
The plotted region will correspond to the smallest equilateral triangle
that encompasses the specified ranges or coordinates.}

\item{lab.cex, tip.cex}{Numeric specifying character expansion (font size)
for axis labels.
Use a vector of length three to specify a different value for each direction.}

\item{lab.font, tip.font}{Numeric specifying font style (Roman, bold, italic,
bold-italic) for axis titles.
Use a vector of length three to set a different font for each direction.}

\item{isometric}{Logical specifying whether to enforce an equilateral shape
for the ternary plot.
If only one of \code{xlim} and \code{ylim} is set, the other will be calculated to
maintain an equilateral plot.
If both \code{xlim} and \code{ylim} are set, but have different ranges, then the limit
with the smaller range will be scaled until its range matches that of the
other limit.}

\item{atip.rotate, btip.rotate, ctip.rotate}{Integer specifying number of
degrees to rotate label of rightmost apex.}

\item{atip.pos, btip.pos, ctip.pos}{Integer specifying positioning of labels,
iff the corresponding \code{xtip.rotate} parameter is set.}

\item{padding}{Numeric specifying size of internal margin of the plot;
increase if axis labels are being clipped.}

\item{col}{The colour for filling the plot; see
\code{\link[graphics]{polygon}}.}

\item{panel.first}{An expression to be evaluated after the plot axes are
set up but before any plotting takes place.
This can be useful for drawing backgrounds, e.g. with \code{\link[=ColourTernary]{ColourTernary()}}
or \code{\link[=HorizontalGrid]{HorizontalGrid()}}.
Note that this works by lazy evaluation: passing this argument from other
plot methods may well not work since it may be evaluated too early.}

\item{panel.last}{An expression to be evaluated after plotting has taken
place but before the axes and box are added.  See the comments about
\code{panel.first}.}

\item{grid.lines}{Integer specifying the number of grid lines to plot.
If \code{axis.labels = TRUE}, this will be used as a hint to \code{pretty()}.}

\item{grid.col, grid.minor.col}{Colours to draw the grid lines. Use a vector
of length three to set different values for each direction.}

\item{grid.lty, grid.minor.lty}{Character or integer vector; line type of
the grid lines. Use a vector of length three to set different values for
each direction.}

\item{grid.lwd, grid.minor.lwd}{Non-negative numeric giving line width of the
grid lines.  Use a vector of length three to set different values for each
direction.}

\item{grid.minor.lines}{Integer specifying the number of minor (unlabelled)
grid lines to plot between each major pair.}

\item{hex.border, hex.lty, hex.lwd}{Parameters to pass to
\code{HoldridgeHexagons()}.  Set to \code{NA} to suppress hexagons.}

\item{hex.col}{Fill colour for hexagons.  Provide a vector specifying a
colour for each hexagon in turn, reading from left to right and top to
bottom, or a function that accepts two arguments, numerics \code{pet} and \code{prec},
and returns a colour in a format accepted by
\code{\link[graphics:polygon]{polygon()}}.}

\item{hex.cex, hex.font, hex.text.col}{Parameters passed to
\code{\link[graphics:text]{text()}} to plot \code{hex.labels}.}

\item{hex.labels}{38-element character vector specifying label for
each hexagonal class, from top left to bottom right.}

\item{axis.cex}{Numeric specifying character expansion (font size)
for axis labels.
Use a vector of length three to set a different value for each direction.}

\item{axis.col, ticks.col, tip.col}{Colours for the axis line,
tick marks and tip labels respectively.
Use a vector of length three to set a different value for each direction.
\code{axis.col = NULL} means to use \code{par('fg')}, possibly specified
inline, and \code{ticks.col = NULL} means to use whatever colour
\code{axis.col} resolved to.}

\item{axis.font}{Font for text. Defaults to \code{par('font')}.}

\item{axis.labels}{This can either be a logical value specifying whether
(numerical) annotations are to be made at the tickmarks, or a character or
expression vector of labels to be placed at the tick points,
or a list of length three, with each entry specifying labels to be placed
on each axis in turn.}

\item{axis.lty}{Line type for both the axis line and tick marks.
Use a vector of length three to set a different value for each direction.}

\item{axis.lwd, ticks.lwd}{Line width for the axis line and tick marks.
Zero or negative values will suppress the line or ticks.
Use a vector of length three to set different values for each axis.}

\item{axis.rotate}{Logical specifying whether to rotate axis labels
to parallel grid lines, or numeric specifying custom rotation for each axis,
to be passed as \code{srt} parameter to \code{text()}.  Expand margins or set
\code{par(xpd = NA)} if labels are clipped.}

\item{axis.pos}{Vector of length one or three specifying position of axis
labels, to be passed as \code{pos} parameter to \code{text()}; populated automatically
if \code{NULL} (the default).}

\item{axis.tick}{Logical specifying whether to mark the axes with tick marks.}

\item{ticks.length}{Numeric specifying distance that ticks should extend
beyond the plot margin.  Also affects position of axis labels, which are
plotted at the end of each tick.
Use a vector of length three to set a different length for each direction.}

\item{...}{Additional parameters to \code{\link[graphics]{plot}}.}

\item{border}{Colour to use for hexagon borders.}

\item{lty, lwd, cex, font}{\link[graphics:par]{Graphical parameters} specifying
properties of hexagons to be plotted.}

\item{labels}{Vector specifying labels for life zone hexagons to be plotted.
Suggested values: \code{\link{holdridgeClassesUp}}, \code{\link{holdridgeLifeZonesUp}}.}

\item{text.col}{Colour of text to be printed in hexagons.}
}
\description{
\code{HoldridgePlot()} creates a blank triangular plot, as proposed by
Holdridge (1947, 1967), onto which potential evapotranspiration
(\acronym{PET}) ratio and annual precipitation data can be plotted
(using the \code{\link[=AddToHoldridge]{AddToHoldridge()}} family of functions) in order to interpret
climatic life zones.
}
\details{
\code{\link[=HoldridgePoints]{HoldridgePoints()}}, \code{\link[=HoldridgeText]{HoldridgeText()}} and related functions allow data
points to be added to an existing plot; \code{\link[=AddToHoldridge]{AddToHoldridge()}} allows plotting
using any of the standard plotting functions.

\code{\link[=HoldridgeBelts]{HoldridgeBelts()}} and \code{\link[=HoldridgeHexagons]{HoldridgeHexagons()}} plot interpretative lines
and hexagons allowing plotted data to be linked to interpreted climate
settings.

Please cite Tsakalos \emph{et al.} (2023) when using this function.
}
\examples{
data(holdridgeLifeZonesUp, package = "Ternary")
HoldridgePlot(hex.labels = holdridgeLifeZonesUp)
HoldridgeBelts()
}
\references{
Holdridge (1947),
"Determination of world plant formations from simple climatic data",
\emph{Science} 105:367–368. \doi{10.1126/science.105.2727.367}

Holdridge (1967), \emph{Life zone ecology}.
Tropical Science Center, San José

Tsakalos, Smith, Luebert & Mucina (2023).
"climenv: Download, extract and visualise climatic and elevation data.",
\emph{Journal of Vegetation Science} 6:e13215. \doi{10.1111/jvs.13215}
}
\seealso{
Other Holdridge plotting functions: 
\code{\link{AddToTernary}()},
\code{\link{HoldridgeHypsometricCol}()},
\code{\link{holdridge}},
\code{\link{holdridgeClasses}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Holdridge plotting functions}
