% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_methods.R
\name{summary.tsqca_result}
\alias{summary.tsqca_result}
\alias{summary.otSweep_result}
\alias{summary.dtSweep_result}
\alias{summary.ctSweepS_result}
\alias{summary.ctSweepM_result}
\title{Summary method for TSQCA results}
\usage{
\method{summary}{tsqca_result}(object, ...)

\method{summary}{otSweep_result}(object, ...)

\method{summary}{dtSweep_result}(object, ...)

\method{summary}{ctSweepS_result}(object, ...)

\method{summary}{ctSweepM_result}(object, ...)
}
\arguments{
\item{object}{A TSQCA result object returned by one of the sweep functions.}

\item{...}{Additional arguments (ignored).}
}
\value{
Invisibly returns \code{object}.
}
\description{
Displays detailed results table with solution formulas and fit measures.
}
\examples{
\donttest{
data(sample_data)
result <- otSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:8,
  thrX = c(X1 = 7, X2 = 7, X3 = 7)
)
summary(result)
}

}
