icm_test_boot <- function(X, n.boot = 200, score = "Identity", weight = "Gauss", 
                          ica = "JADE", ncores = NULL, iseed = NULL, eps = 1e-06, 
                          maxiter = 100, g = "tanh", method = "sym", inR = FALSE, n.init = 2) {
  
  # Match arguments 
  score <- match.arg(score, c("Identity", "Rank", "VdW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  ica <- match.arg(ica, c("JADE", "FOBI", "fICA"))
  
  # Create a unique method name based on inputs
  method <- paste0("ICAtest", score, weight, ica, "_par")
  
  # Switch to select the appropriate function and execute it
  res <- switch(method,
                ICAtestIdentityGaussJADE_par = ICAtestGauss_jade_par(X, n.boot, eps, maxiter, ncores, iseed),
                ICAtestIdentityGaussFOBI_par = ICAtestGauss_fobi_par(X, n.boot, ncores, iseed),
                ICAtestIdentityGaussfICA_par = ICAtestGauss_fICA_par(X, n.boot, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestIdentityLaplaceJADE_par = ICAtestLap_jade_par(X, n.boot, eps, maxiter, ncores, iseed),
                ICAtestIdentityLaplaceFOBI_par = ICAtestLap_fobi_par(X, n.boot, ncores, iseed),
                ICAtestIdentityLaplacefICA_par = ICAtestLap_fICA_par(X, n.boot, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestRankGaussJADE_par = ICAtestRankGauss_jade_par(X, n.boot, eps, maxiter, ncores, iseed),
                ICAtestRankGaussFOBI_par = ICAtestRankGauss_fobi_par(X, n.boot, ncores, iseed),
                ICAtestRankGaussfICA_par = ICAtestRankGauss_fICA_par(X, n.boot, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestRankLaplaceJADE_par = ICAtestRankLap_jade_par(X, n.boot, eps, maxiter, ncores, iseed),
                ICAtestRankLaplaceFOBI_par = ICAtestRankLap_fobi_par(X, n.boot, ncores, iseed),
                ICAtestRankLaplacefICA_par = ICAtestRankLap_fICA_par(X, n.boot, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestVdWGaussJADE_par = ICAtestRankvdW_jade_par(X, n.boot, eps, maxiter, ncores, iseed),
                ICAtestVdWGaussFOBI_par = ICAtestRankvdW_fobi_par(X, n.boot, ncores, iseed),
                ICAtestVdWGaussfICA_par = ICAtestRankvdW_fICA_par(X, n.boot, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                stop("Unsupported method combination"))
  
  # Add the score and weight information to the result list
  res$score <- score
  res$weight <- weight
  res$ica <- ica
  
  return(res)
}
