ANOVA_table <- function(data) {

  # Convert the first two columns to factor type
  data[, 1:2] <- lapply(data[, 1:2], as.factor)

  # Convert the remaining columns to numeric
  data[, -c(1, 2)] <- lapply(data[, -c(1, 2)], as.numeric)

  # Extract trait names (excluding the first two columns)
  traits <- names(data)[-c(1, 2)]

  # Initialize results data frame with corrected column name
  results <- data.frame("Source of variation" = c(names(data)[1], names(data)[2], "Residuals"),
                        "Df" = numeric(3),
                        stringsAsFactors = FALSE)

  # Loop through each trait
  for (trait in traits) {

    # Perform linear regression
    formula <- as.formula(paste0("`", trait, "` ~ `", names(data)[1], "` + `", names(data)[2], "`"))
    model <- lm(formula, data = data)

    # Perform ANOVA
    anova_result <- anova(model)

    # Extract degrees of freedom, mean squares, and p-values
    degrees_of_freedom <- anova_result$Df
    mean_squares <- round(anova_result$`Mean Sq`, 2)
    p_values <- anova_result$`Pr(>F)`[1:2]

    # Update degrees of freedom in the results data frame
    results[["Df"]] <- degrees_of_freedom

    # Determine significance levels
    significance <- ifelse(p_values < 0.05, "*", "NS")


    # Combine mean squares with significance levels
    formatted_results <- c(paste0(mean_squares[1], " ", significance[1]),
                           paste0(mean_squares[2], " ", significance[2]),
                           mean_squares[3])

    # Add results to the data frame
    results[[trait]] <- formatted_results
  }

  # Correcting the column name
  colnames(results)[1] <- "Source of variation"

  # Return the results
  return(results)
}
