% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{as.data.frame.sdbuildR_xmile}
\alias{as.data.frame.sdbuildR_xmile}
\title{Convert stock-and-flow model to data frame}
\usage{
\method{as.data.frame}{sdbuildR_xmile}(
  x,
  row.names = NULL,
  optional = FALSE,
  type = NULL,
  name = NULL,
  properties = NULL,
  ...
)
}
\arguments{
\item{x}{A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{row.names}{NULL or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{Ignored parameter.}

\item{type}{Variable types to retain in the data frame. Must be one or more of 'stock', 'flow', 'constant', 'aux', 'gf', 'macro', or 'model_units'. Defaults to NULL to include all types.}

\item{name}{Variable names to retain in the data frame. Defaults to NULL to include all variables.}

\item{properties}{Variable properties to retain in the data frame. Defaults to NULL to include all properties.}

\item{...}{Optional arguments}
}
\value{
A data.frame with one row per model component (variable, unit definition, or macro).
Common columns include \code{type} (component type), \code{name} (variable name),
\code{eqn} (equation), \code{units} (units of measurement), and \code{label}
(descriptive label). Additional columns may include \code{to}, \code{from},
\code{non_negative}, and others depending on variable types. The exact columns returned
depend on the \code{type} and \code{properties} arguments. Returns an empty data.frame
if no components match the filters.
}
\description{
Create a data frame with properties of all model variables, model units, and macros. Specify the variable types, variable names, and/or properties to get a subset of the data frame.
}
\examples{
as.data.frame(xmile("SIR"))

# Only show stocks
as.data.frame(xmile("SIR"), type = "stock")

# Only show equation and label
as.data.frame(xmile("SIR"), properties = c("eqn", "label"))

}
\concept{build}
