% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{edge_style_options}
\alias{edge_style_options}
\title{Create Edge Style Options for G6 Graphs}
\usage{
edge_style_options(
  class = NULL,
  cursor = valid_cursors,
  fill = NULL,
  fillRule = c("nonzero", "evenodd"),
  filter = NULL,
  increasedLineWidthForHitTesting = NULL,
  isBillboard = TRUE,
  lineDash = 0,
  lineDashOffset = 0,
  lineWidth = 1,
  opacity = 1,
  pointerEvents = NULL,
  shadowBlur = NULL,
  shadowColor = NULL,
  shadowOffsetX = NULL,
  shadowOffsetY = NULL,
  shadowType = NULL,
  sourcePort = NULL,
  stroke = "#000",
  strokeOpacity = 1,
  targetPort = NULL,
  transform = NULL,
  transformOrigin = NULL,
  visibility = c("visible", "hidden"),
  zIndex = -10000,
  ...
)
}
\arguments{
\item{class}{Edge class name for custom styling with CSS. Default: NULL.}

\item{cursor}{Edge mouse hover cursor style. Common values include "default",
"pointer", "move", etc. Default: "default".}

\item{fill}{Edge area fill color (for edges with area, like loops). Default: NULL.}

\item{fillRule}{Edge internal fill rule. Options: "nonzero", "evenodd". Default: NULL.}

\item{filter}{Edge shadow filter effect. Default: NULL.}

\item{increasedLineWidthForHitTesting}{When the edge width is too small, this value increases
the interaction area to make edges easier to interact with. Default: NULL.}

\item{isBillboard}{Effective in 3D scenes, always facing the screen so the line width
is not affected by perspective projection. Default: TRUE.}

\item{lineDash}{Edge dashed line style. Numeric vector specifying dash pattern. Default: 0.}

\item{lineDashOffset}{Edge dashed line offset. Default: 0.}

\item{lineWidth}{Edge width in pixels. Default: 1.}

\item{opacity}{Overall opacity of the edge. Value between 0 and 1. Default: 1.}

\item{pointerEvents}{Whether the edge responds to pointer events. Default: NULL.}

\item{shadowBlur}{Edge shadow blur effect amount. Default: NULL.}

\item{shadowColor}{Edge shadow color. Default: NULL.}

\item{shadowOffsetX}{Edge shadow X-axis offset. Default: NULL.}

\item{shadowOffsetY}{Edge shadow Y-axis offset. Default: NULL.}

\item{shadowType}{Edge shadow type. Options: "inner", "outer", "both". Default: NULL.}

\item{sourcePort}{Source port of the edge connection. Default: NULL.}

\item{stroke}{Edge color. Default: "#000".}

\item{strokeOpacity}{Edge color opacity. Value between 0 and 1. Default: 1.}

\item{targetPort}{Target port of the edge connection. Default: NULL.}

\item{transform}{CSS transform attribute to rotate, scale, skew, or translate the edge.
Default: NULL.}

\item{transformOrigin}{Rotation and scaling center point. Default: NULL.}

\item{visibility}{Whether the edge is visible. Options: "visible", "hidden". Default: "visible".}

\item{zIndex}{Edge rendering level (for layering). Default: 1.}

\item{...}{Extra parameters.}
}
\value{
A list containing edge style options that can be passed to \code{\link[=edge_options]{edge_options()}}.
}
\description{
Configures the styling options for edges in a G6 graph. These settings control
the appearance and interaction behavior of edges.
}
\details{
Edge style options allow fine-grained control over how edges are rendered and
behave in a G6 graph. This includes colors, widths, line styles, shadows, visibility,
and interaction properties.
}
