% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{RRIk4}
\alias{RRIk4}
\alias{RRIk4.numeric}
\alias{RRIk4.SpatRaster}
\title{RRIk4: Radial Roughness index with fourth order differences}
\usage{
RRIk4(x, ...)

\method{RRIk4}{numeric}(x, ...)

\method{RRIk4}{SpatRaster}(x, ..., .method = c("rcpp", "r"))
}
\arguments{
\item{x}{A DEM/image as a SpatRaster or a vector of numeric values from a focal window in a DEM from which to compute the index}

\item{...}{reserved for future use}

\item{.method}{Either \code{r} or \code{rcpp} (fast batch processing using C++)}
}
\value{
RRIk4 (in the same units of input)
}
\description{
RRI based on increments of order 4, permits the filtering of curvature (filters a polynomial of order 3),
always using a 5x5 kernel.
The input is the DEM/image (no need to detrend).
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
roughRRIk4=RRIk4(dem)
plot(roughRRIk4)
}
\references{
\enumerate{
\item Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology,
\doi{doi:10.1016/j.geomorph.2023.108838}.
\item Trevisani, S., Guth, P.L., 2025. Surface Roughness in Geomorphometry: From Basic Metrics Toward a Coherent Framework.
Remote Sensing 17, \doi{doi:10.3390/rs17233864}.
}
}
