% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuperGauss-package.R
\docType{package}
\name{SuperGauss-package}
\alias{SuperGauss}
\alias{SuperGauss-package}
\title{Superfast inference for stationary Gaussian time series.}
\description{
Likelihood evaluations for stationary Gaussian time series are typically obtained via the Durbin-Levinson algorithm, which scales as O(n^2) in the number of time series observations. This package provides a "superfast" O(n log^2 n) algorithm written in C++, crossing over with Durbin-Levinson around n = 300. Efficient implementations of the score and Hessian functions are also provided, leading to superfast versions of inference algorithms such as Newton-Raphson and Hamiltonian Monte Carlo. The C++ code provides a Toeplitz matrix class packaged as a header-only library, to simplify low-level usage in other packages and outside of R.
}
\details{
While likelihood calculations with stationary Gaussian time series generally scale as \code{O(N^2)} in the number of observations, this package implements an algorithm which scales as \verb{O(N log^2 N)}.  "Superfast" algorithms for loglikelihood gradients and Hessians are also provided.  The underlying C++ code is distributed through a header-only library found in the installed package's \code{include} directory.
}
\examples{
# Superfast inference for the timescale parameter
# of the exponential autocorrelation function
exp_acf <- function(lambda) exp(-(1:N-1)/lambda)

# simulate data
lambda0 <- 1
N <- 1000
X <- rnormtz(n = 1, acf = exp_acf(lambda0))

# loglikelihood function
# allocate memory for a NormalToeplitz distribution object
NTz <- NormalToeplitz$new(N)
loglik <- function(lambda) {
  NTz$logdens(z = X, acf = exp_acf(lambda))
  ## dSnorm(X = X, acf = Toep, log = TRUE)
}

# maximum likelihood estimation
optimize(f = loglik, interval = c(.2, 5), maximum = TRUE)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mlysy/SuperGauss}
  \item Report bugs at \url{https://github.com/mlysy/SuperGauss/issues}
}

}
\author{
\strong{Maintainer}: Martin Lysy \email{mlysy@uwaterloo.ca}

Authors:
\itemize{
  \item Yun Ling
}

}
