% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_get_comid.R
\name{sc_get_comid}
\alias{sc_get_comid}
\title{Get COMIDs}
\usage{
sc_get_comid(dd = NULL, xcoord = NULL, ycoord = NULL, crsys = NULL)
}
\arguments{
\item{dd}{Name of data frame object.  Can be a simple
data frame with coordinate columns in a known CRS or
an sf points data frame}

\item{xcoord}{The x coordinate column if using a raw data
frame}

\item{ycoord}{The y coordinate column if using a raw data 
frame}

\item{crsys}{The epsg code if using a raw data frame}
}
\value{
A new sf data frame with a populated 'COMID' column
}
\description{
Function to return NHDPlusV2 COMIDS using either a 
dataframe with coordinates and a specified CRS or an 
sf object.  The function generates a vector of COMID
values a user can then pass to sc_get_data function
}
\examples{
\dontrun{

dd <- data.frame(x = c(-122.649,-100.348,-75.186,-106.675),
y = c(45.085, 35.405,42.403,38.721))

comids <- sc_get_comid(dd, xcoord='x',
                       ycoord='y', crsys=4269)

dd <- sf::st_point_on_surface(sf::read_sf(system.file("shape/nc.shp", package="sf")))

comids <- sc_get_comid(dd)
                                  
comids <- sc_get_comid(dd, xcoord='x', 
ycoord='y', crsys=4269)

dd <- sf::read_sf(system.file("shape/nc.shp", package="sf"))
comids <- sc_get_comid(dd)

 }
}
\author{
Marc Weber
}
