% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{[,simList,character,ANY-method}
\alias{[,simList,character,ANY-method}
\title{Extract an intact \code{simList} but with subset of objects}
\usage{
\S4method{[}{simList,character,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{A \code{simList}}

\item{i}{A character vector of objects to select.}

\item{j}{Not used.}

\item{...}{Not used.}

\item{drop}{Not used.}
}
\value{
The \code{[} method returns a complete \code{simList} class with all the slots
copied from the original, but only the named objects in \code{i} are returned.
}
\description{
This is copies the non-object components of a \code{simList} (e.g., events, etc.)
then selects only the objects listed in \code{i} using \code{Copy(mget(i, envir(sim)))}
and adds them to the returned \code{simList}.
}
\examples{
s <- simInit()
s$a <- 1
s$b <- 2
s$d <- 3
s[c("a", "d")] # a simList with only 2 objects


}
\author{
Eliot McIntire
}
