% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region-enrichment.R
\name{TSSEnrichment}
\alias{TSSEnrichment}
\title{Compute TSS enrichment score per cell}
\usage{
TSSEnrichment(
  object,
  tss.positions = NULL,
  n = NULL,
  fast = TRUE,
  assay = NULL,
  cells = NULL,
  process_n = 2000,
  verbose = TRUE,
  region_extension = 1000
)
}
\arguments{
\item{object}{A Seurat object}

\item{tss.positions}{A GRanges object containing the TSS positions. If NULL,
use the genomic annotations stored in the assay.}

\item{n}{Number of TSS positions to use. This will select the first _n_
TSSs from the set. If NULL, use all TSSs (slower).}

\item{fast}{Just compute the TSS enrichment score, without storing the
base-resolution matrix of integration counts at each site. This reduces the
memory required to store the object but does not allow plotting the
accessibility profile at the TSS.}

\item{assay}{Name of assay to use}

\item{cells}{A vector of cells to include. If NULL (default), use all cells
in the object}

\item{process_n}{Number of regions to process at a time if using \code{fast}
option.}

\item{verbose}{Display messages}

\item{region_extension}{Distance extended upstream and downstream from TSS
in which to calculate enrichment and background.}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object
}
\description{
Compute the transcription start site (TSS) enrichment score for each cell,
as defined by ENCODE:
\url{https://www.encodeproject.org/data-standards/terms/}.
}
\details{
The computed score will be added to the object metadata as "TSS.enrichment".
}
\examples{
\dontrun{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
Fragments(atac_small) <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  tolerance = 0.5
)
TSSEnrichment(object = atac_small)
}
}
\concept{qc}
