% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm3d.R
\name{norm3d}
\alias{norm3d}
\title{Trivariate normal density with independent components in space-time}
\usage{
norm3d(x, y, t, mu = c(0.3, 0.3, 0.2), sd = c(0.05, 0.05, 0.05), log = FALSE)
}
\arguments{
\item{x}{Numeric vector of x-coordinate(s).}

\item{y}{Numeric vector of y-coordinate(s).}

\item{t}{Numeric vector of time coordinate(s).}

\item{mu}{Numeric vector of length 3 giving \code{c(mu_x, mu_y, mu_t)}.}

\item{sd}{Numeric vector of length 3 giving positive standard deviations \code{c(sd_x, sd_y, sd_t)}.}

\item{log}{Logical; if \code{TRUE}, return the log-density.}
}
\value{
Numeric vector of densities (or log-densities) with length determined by standard
recycling rules for \code{x}, \code{y}, and \code{t}.
}
\description{
Evaluates a trivariate normal density on \eqn{(x,y,t)} with independent components
(diagonal covariance). The density is the product of three univariate normal densities:
\deqn{f(x,y,t) = \phi(x;\mu_x,\sigma_x)\,\phi(y;\mu_y,\sigma_y)\,\phi(t;\mu_t,\sigma_t).}
}
\examples{

norm3d(0.3, 0.3, 0.2)  # peak value at the mean (with default parameters)
norm3d(c(0.2, 0.3), 0.3, 0.2)

x <- y <- seq(0, 1, length.out = 100)
z <- outer(x, y, function(x, y) norm3d(x, y, t = 0.2))
image(x, y, z, col = heat.colors(50), main = "Spatial slice of norm3d at t = 0.2")

}
\references{
Ghorbani, M., Vafaei, N., Dvořák, J., and Myllymäki, M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{norm2d}}, \code{\link{get.lambda.function}}, \code{\link{estimate.st.intensity}}
}
\author{
Mohammad Ghorbani \email{mohammad.ghorbani@slu.se}\cr
}
