% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-functions.R
\name{estimate_functions}
\alias{estimate_functions}
\alias{estimate_k_generic}
\alias{estimate_k_generic_1RM}
\alias{estimate_k}
\alias{estimate_k_1RM}
\alias{estimate_kmod}
\alias{estimate_kmod_1RM}
\alias{estimate_klin}
\alias{estimate_klin_1RM}
\alias{get_predicted_1RM_from_k_model}
\title{Estimate relationship between reps and \%1RM (or weight)}
\usage{
estimate_k_generic(
  perc_1RM,
  reps,
  eRIR = 0,
  k = 0.0333,
  reverse = FALSE,
  weighted = "none",
  ...
)

estimate_k_generic_1RM(
  weight,
  reps,
  eRIR = 0,
  k = 0.0333,
  reverse = FALSE,
  weighted = "none",
  ...
)

estimate_k(perc_1RM, reps, eRIR = 0, reverse = FALSE, weighted = "none", ...)

estimate_k_1RM(weight, reps, eRIR = 0, reverse = FALSE, weighted = "none", ...)

estimate_kmod(
  perc_1RM,
  reps,
  eRIR = 0,
  reverse = FALSE,
  weighted = "none",
  ...
)

estimate_kmod_1RM(
  weight,
  reps,
  eRIR = 0,
  reverse = FALSE,
  weighted = "none",
  ...
)

estimate_klin(
  perc_1RM,
  reps,
  eRIR = 0,
  reverse = FALSE,
  weighted = "none",
  ...
)

estimate_klin_1RM(
  weight,
  reps,
  eRIR = 0,
  reverse = FALSE,
  weighted = "none",
  ...
)

get_predicted_1RM_from_k_model(model)
}
\arguments{
\item{perc_1RM}{\%1RM}

\item{reps}{Number of repetitions done}

\item{eRIR}{Subjective estimation of reps-in-reserve (eRIR)}

\item{k}{Value for the generic Epley's equation, which is by default equal to 0.0333}

\item{reverse}{Logical, default is \code{FALSE}. Should reps be used as predictor instead as a target?}

\item{weighted}{What weighting should be used for the non-linear regression? Default is "none". Other options include:
"reps" (for 1/reps weighting), "load" (for using weight or \%1RM), "eRIR" (for 1/(eRIR+1) weighting),
"reps x load", "reps x eRIR", "load x eRIR", and "reps x load x eRIR"}

\item{...}{Forwarded to \code{\link[minpack.lm]{nlsLM}} function}

\item{weight}{Weight used}

\item{model}{Object returned from the  \code{\link{estimate_k_1RM}} function}
}
\value{
\code{\link[minpack.lm]{nlsLM}} object
}
\description{
By default, target variable is the reps performed, while the predictors is the \code{perc_1RM} or
\code{weight}. To reverse this, use the \code{reverse = TRUE} argument
}
\section{Functions}{
\itemize{
\item \code{estimate_k_generic()}: Provides the model with generic \code{k} parameter

\item \code{estimate_k_generic_1RM()}: Provides the model with generic \code{k} parameter, as well as
estimated \code{1RM}. This is a novel estimation function that uses the absolute weights.

\item \code{estimate_k()}: Estimate the parameter \code{k} in the Epley's equation

\item \code{estimate_k_1RM()}: Estimate the parameter \code{k} in the Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights.

\item \code{estimate_kmod()}: Estimate the parameter \code{kmod} in the modified Epley's equation

\item \code{estimate_kmod_1RM()}: Estimate the parameter \code{kmod} in the modified Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_klin()}: Estimate the parameter \code{klin} using the Linear/Brzycki model

\item \code{estimate_klin_1RM()}: Estimate the parameter \code{klin} in the Linear/Brzycki equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{get_predicted_1RM_from_k_model()}: Estimate the 1RM from \code{\link{estimate_k_1RM}} function

The problem with Epley's estimation model (implemented in \code{\link{estimate_k_1RM}} function)
is that it predicts the 1RM when nRM = 0. Thus, the estimated parameter in the model produced
by the \code{\link{estimate_k_1RM}} function is not 1RM, but 0RM. This function calculates the
weight at nRM = 1 for both the normal and reverse model. See Examples for code

}}
\examples{
# ---------------------------------------------------------
# Generic Epley's model
m1 <- estimate_k_generic(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Generic Epley's model that also estimates 1RM
m1 <- estimate_k_generic_1RM(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Epley's model
m1 <- estimate_k(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Epley's model that also estimates 1RM
m1 <- estimate_k_1RM(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Modified Epley's model
m1 <- estimate_kmod(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Modified Epley's model that also estimates 1RM
m1 <- estimate_kmod_1RM(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model
m1 <- estimate_klin(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model thal also estimates 1RM
m1 <- estimate_klin_1RM(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Estimating 1RM from Epley's model
m1 <- estimate_k_1RM(150 * c(0.9, 0.8, 0.7), c(3, 6, 12))
m2 <- estimate_k_1RM(150 * c(0.9, 0.8, 0.7), c(3, 6, 12), reverse = TRUE)

# Estimated 0RM values from both model
c(coef(m1)[[1]], coef(m2)[[1]])

# But these are not 1RMs!!!
# Using the "reverse" model, where nRM is the predictor (in this case m2)
# makes it easier to predict 1RM
predict(m2, newdata = data.frame(nRM = 1))

# But for the normal model it involve reversing the formula
# To spare you from the math pain, use this
get_predicted_1RM_from_k_model(m1)

# It also works for the "reverse" model
get_predicted_1RM_from_k_model(m2)
}
