% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_utils.R
\name{substitute_formula_vars}
\alias{substitute_formula_vars}
\title{Replace variables in formula with sum of other variables}
\usage{
substitute_formula_vars(
  f,
  replacements,
  simplify = FALSE,
  env = parent.frame()
)
}
\arguments{
\item{f}{A model formula.}

\item{replacements}{A named list. The names of \code{replacements} must correspond to variables in \code{f}.
Each element in \code{replacements} must be a character vector consisting of
the variables you wish to replace.}

\item{simplify}{Logical, default is FALSE. Determines whether the formula
should be expanded and simplified before output or not.}

\item{env}{The environment for the output formula.}
}
\value{
model formula
}
\description{
Replace variables in formula with sum of other variables
}
\examples{
f <- ~b + a*c  + b:d
substitute_formula_vars(f, list(a = c("hello", "world", "b"), 
                                b = c("Q1", "Q2")))

}
\author{
Daniel Lupp and Øyvind Langsrud
}
\keyword{internal}
