% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_clusters.R
\name{estimate_clusters}
\alias{estimate_clusters}
\title{Estimate observational and distributional clusters}
\usage{
estimate_clusters(object, burnin = 0, ncores = 0)
}
\arguments{
\item{object}{object of class \code{SANmcmc} (the result of a call to \code{\link{sample_fiSAN}}, 
\code{\link{sample_fSAN}}, or \code{\link{sample_CAM}}).}

\item{burnin}{the length of the burn-in to be discarded before estimating the clusters (default is 2/3 of the iterations).}

\item{ncores}{the number of CPU cores to use, i.e., the number of simultaneous runs at any given time. A value of zero indicates to use all cores on the system.}
}
\value{
Object of class \code{SANclusters}. The object contains:

\code{est_oc} estimated partition at the observational level. It is an object of class \code{salso.estimate}.

\code{est_dc} estimated partition at the distributional level. It is an object of class \code{salso.estimate}.

\code{clus_means} cluster-specific sample means of the estimated partition.

\code{clus_vars} cluster-specific sample variances of the estimated partition.
}
\description{
Given the MCMC output, estimate the observational and distributional partitions using \code{\link[salso:salso]{salso::salso()}}.
}
\examples{
set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1,30), rep(2, 30))
out <- sample_fiSAN(nrep = 500, burn = 200,
                     y = y, group = g, 
                    nclus_start = 2,
                    maxK = 20, maxL = 20,
                    beta = 1)
estimate_clusters(out)

}
\seealso{
\code{\link[salso:salso]{salso::salso()}}, \code{\link{print.SANmcmc}}, \code{\link{plot.SANmcmc}}, \code{\link{print.SANclusters}}
}
