% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_env_bins.R
\name{plot_env_bins}
\alias{plot_env_bins}
\title{Plot Environmental Bins (2D Projection)}
\usage{
plot_env_bins(
  env_bins,
  x_var,
  y_var,
  alpha_blocks = 0.3,
  color_points = "black",
  size_points = 2,
  alpha_points = 0.5,
  stroke_points = 1,
  xlab = NULL,
  ylab = NULL,
  theme_plot = ggplot2::theme_minimal()
)
}
\arguments{
\item{env_bins}{(list) output list from \code{get_env_bins()}. Must contain:
\itemize{
\item \code{data}: data.frame with environmental values, bin indices, and block_id
\item \code{breaks}: named list with breakpoints for each variable
}}

\item{x_var}{(character) name of the environmental variable used on the
x-axis.}

\item{y_var}{(character) name of the environmental variable used on the
y-axis.}

\item{alpha_blocks}{(numeric) transparency level of the block rectangles.
Must be between 0 and 1. Default is 0.3.}

\item{color_points}{(character) color of the points representing occurrence
records. Default is \code{"black"}.}

\item{size_points}{(numeric) size of the points representing occurrence
records. Default is 2.}

\item{alpha_points}{(numeric) transparency level of the points. Must be
between 0 and 1. Default is 0.5..}

\item{stroke_points}{(numeric) size of the border of the points. Default is
1.}

\item{xlab}{(character) label for the x-axis. Default is \code{NULL}, meaning
the name provided in \code{x_var} will be used.}

\item{ylab}{(character) label for the y-axis. Default is \code{NULL}, meaning
the name provided in \code{y_var} will be used.}

\item{theme_plot}{(theme) a \code{ggplot2} theme object. Default is
\code{ggplot2::theme_minimal()}.}
}
\value{
A ggplot object showing the environmental blocks (colored rectangles) and
the occurrence records in the selected environmental space.
}
\description{
Visualize the output of \code{get_env_bins()} by plotting environmental blocks
(bins) along two selected environmental variables. Each block is shown as
a colored rectangle, and points falling inside the same rectangle share the
same \code{block_id}.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Get only occurrences from Araucaria
occ <- occurrences[occurrences$species == "Araucaria angustifolia", ]
# Load example of raster variables
data("worldclim", package = "RuHere")
# Unwrap Packed raster
r <- terra::unwrap(worldclim)
# Get bins
b <- get_env_bins(occ = occ, env_layers = r, n_bins = 10)
# Plot
plot_env_bins(b, x_var = "bio_1", y_var = "bio_12",
              xlab = "Temperature", ylab = "Precipitation")
}
