% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R, R/utils.R
\name{h_diff}
\alias{h_diff}
\alias{h_jac_diff}
\alias{h_risk_ratio}
\alias{h_jac_risk_ratio}
\alias{h_odds_ratio}
\alias{h_jac_odds_ratio}
\alias{h_log_risk_ratio}
\alias{h_jac_log_risk_ratio}
\alias{h_log_odds_ratio}
\alias{h_jac_log_odds_ratio}
\alias{eff_jacob}
\alias{pairwise}
\alias{against_ref}
\alias{custom_contrast}
\title{Contrast Functions and Jacobians}
\usage{
h_diff(x, y)

h_jac_diff(x, y)

h_risk_ratio(x, y)

h_jac_risk_ratio(x, y)

h_odds_ratio(x, y)

h_jac_odds_ratio(x, y)

h_log_risk_ratio(x, y)

h_jac_log_risk_ratio(x, y)

h_log_odds_ratio(x, y)

h_jac_log_odds_ratio(x, y)

eff_jacob(f)

pairwise(levels, x = levels)

against_ref(levels, ref = levels[1], x = tail(levels, -1))

custom_contrast(levels, x, y)
}
\arguments{
\item{x}{(\code{vector}) A vector of treatment levels.}

\item{y}{(\code{vector}) A vector of treatment levels.}

\item{f}{(\code{function}) Function with argument x and y to compute treatment effect.}

\item{levels}{(\code{character}) Levels of the treatment.}

\item{ref}{(\code{string} or \code{int}) Reference level.}
}
\value{
Vector of contrasts, or matrix of jacobians.

A list of \code{contrast} object with following elements:
\itemize{
\item Index of the treatment group.
\item Index of the reference group.
Additional attributes include \code{levels} and \code{max_levels} indicating the
names of the treatment levels and the maximum number of levels.
}
}
\description{
Contrast Functions and Jacobians

Create Contrast of Pairs
}
\examples{
h_diff(1:3, 4:6)
h_jac_risk_ratio(1:3, 4:6)
}
