% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_none}
\alias{prior_none}
\title{Creates a prior distribution}
\usage{
prior_none(prior_weights = 1)
}
\arguments{
\item{prior_weights}{prior odds associated with a given distribution.
The value is passed into the model fitting function, which creates models
corresponding to all combinations of prior distributions for each of
the model parameters and sets the model priors odds to the product
of its prior distributions.}
}
\value{
\code{prior} and \code{prior_none} return an object of class 'prior'.
A named list containing the distribution name, parameters, and prior weights.
}
\description{
\code{prior} creates a prior distribution.
The prior can be visualized by the \code{plot} function.
}
\examples{
# create a standard normal prior distribution
p1 <- prior(distribution = "normal", parameters = list(mean = 1, sd = 1))

# create a half-normal standard normal prior distribution
p2 <- prior(distribution = "normal", parameters = list(mean = 1, sd = 1),
truncation = list(lower = 0, upper = Inf))

# the prior distribution can be visualized using the plot function
# (see ?plot.prior for all options)
plot(p1)
}
\seealso{
\code{\link[BayesTools:plot.prior]{plot.prior()}}, \link[stats]{Normal}, \link[stats]{Lognormal}, \link[stats]{Cauchy},
\link[stats]{Beta}, \link[stats]{Exponential},
\link[extraDistr]{LocationScaleT}, \link[extraDistr]{InvGamma}.
}
