% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmeans_clustering.R
\name{kmeans_hurst}
\alias{kmeans_hurst}
\title{K-means clustering}
\usage{
kmeans_hurst(X.t, k, ..., N = 100, Q = 2, L = 2)
}
\arguments{
\item{X.t}{A list of data frames. In each data frame, the first column is a numeric time sequence
and the second gives the values of the processes or time series. To get reliable results, it is
recommended to use at least 500 time points. See Examples for usage.}

\item{k}{The desired number of clusters.}

\item{...}{Optional arguments: \code{iter.max}, \code{nstart} and \code{algorithm}.
Refer \code{\link[stats]{kmeans}}.}

\item{N}{Argument used for the estimation of Hurst functions. Number of sub-intervals on which the estimation is performed on. Default is set to 100 sub-intervals.}

\item{Q}{Argument used for the estimation of Hurst functions. Fixed integer greater than or equal to 2. Default is set to 2.}

\item{L}{Argument used for the estimation of Hurst functions. Fixed integer greater than or equal to 2. Default is set to 2.}
}
\value{
An object list of class \code{"k_hurst"} with print and plot methods. The list has following components:
\describe{
\item{\code{cluster_info}}{A data frame indicating the cluster number and euclidean distance to cluster center of
each smoothed estimated Hurst function (item) }
\item{\code{cluster}}{A vector of cluster number of each item.}
\item{\code{cluster_sizes}}{Number of item in each cluster.}
\item{\code{centers}}{A data frame of cluster centers. Center obtained as the average of each smoothed estimated Hurst function in the cluster.
Columns denote time points in which estimates were obtained. Row names denote cluster numbers.}
\item{\code{smoothed_Hurst_estimates}}{A data frame of smoothed Hurst estimates. Columns denote time points in which estimates were obtained.
Rows denote estimates for each realisation.}
\item{\code{raw_Hurst_estimates}}{A list of data frames of raw Hurst estimates.}
\item{\code{call}}{Information about the input parameters used.}
}
}
\description{
This function performs k-means clustering of realisations
based on the estimated Hurst functions.
}
\details{
The Hurst function of each realisation is estimated using \code{\link{Hurst}}. The smoothed Hurst estimates are
used for k-means clustering in \code{\link[stats]{kmeans}}. The Hartigan and Wong algorithm is used as the
default k-means clustering algorithm.
}
\examples{
\donttest{
#Simulation of multifractional processes
t <- seq(0, 1, by = (1/2)^10)
H1 <- function(t) {return(0.1 + 0*t)}
H2 <- function(t) {return(0.2 + 0.45*t)}
H3 <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
X.list.1 <- replicate(3, GHBMP(t, H1),simplify = FALSE)
X.list.2 <- replicate(3, GHBMP(t, H2),simplify = FALSE)
X.list.3 <- replicate(3, GHBMP(t, H3),simplify = FALSE)
X.list <- c(X.list.1, X.list.2, X.list.3)

#K-means clustering based on k = 3 clusters
KC <- kmeans_hurst(X.list, k = 3)
print(KC)

#Plot of smoothed Hurst functions in each cluster with cluster centers
plot(KC, type = "ec")
}
}
\seealso{
\code{\link{print.k_hurst}}, \code{\link{plot.k_hurst}}, \code{\link{hclust_hurst}}
}
