% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGGD.R
\name{dGGD}
\alias{dGGD}
\alias{pGGD}
\alias{qGGD}
\alias{rGGD}
\alias{hGGD}
\title{The Generalized Gompertz  distribution}
\usage{
dGGD(x, mu, sigma, nu, log = FALSE)

pGGD(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qGGD(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rGGD(n, mu, sigma, nu)

hGGD(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, nu}{scale parameter.}

\item{sigma}{shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dGGD} gives the density, \code{pGGD} gives the distribution 
function, \code{qGGD} gives the quantile function, \code{rGGD}
generates random deviates and \code{hGGD} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the generalized Gompertz distribution with
parameters \code{mu} \code{sigma} and \code{nu}.
}
\details{
The Generalized Gompertz  Distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)= \nu \mu \exp(-\frac{\mu}{\sigma}(\exp(\sigma x - 1))) (1 - \exp(-\frac{\mu}{\sigma}(\exp(\sigma x - 1))))^{(\nu - 1)} ,}

for \eqn{x \geq 0}, \eqn{\mu > 0}, \eqn{\sigma \geq 0} and \eqn{\nu > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function 
par(mfrow = c(1, 1))
curve(dGGD(x, mu=1, sigma=0.3, nu=1.5), from = 0, to = 4, 
      col = "red", las = 1, ylab = "f(x)")

## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(pGGD(x, mu=1, sigma=0.3, nu=1.5), from = 0, to = 4, 
      ylim = c(0, 1), col = "red", las = 1, ylab = "F(x)")
curve(pGGD(x, mu=1, sigma=0.3, nu=1.5, lower.tail = FALSE), 
      from = 0, to = 4, ylim = c(0, 1), col = "red", las = 1, ylab = "R(x)")

## The quantile function
p <- seq(from = 0, to = 0.99999, length.out = 100)
plot(x = qGGD(p=p, mu=1, sigma=0.3, nu=1.5), y = p, 
     xlab = "Quantile", las = 1, ylab = "Probability")
curve(pGGD(x, mu=1, sigma=0.3, nu=1.5), from = 0, add = TRUE, 
      col = "red")

## The random function
hist(rGGD(1000, mu=1, sigma=0.3, nu=1.5), freq = FALSE, xlab = "x", 
     las = 1, ylim = c(0, 0.7), main = "")
curve(dGGD(x,mu=1, sigma=0.3, nu=1.5), from = 0, to =8, add = TRUE, 
      col = "red")

## The Hazard function
par(mfrow=c(1,1))
curve(hGGD(x, mu=1, sigma=0.3, nu=1.5), from = 0, to = 3, col = "red",
      ylab = "The hazard function", las = 1)

par(old_par) # restore previous graphical parameters
}
\references{
El-Gohary, A., Alshamrani, A., & Al-Otaibi, A. N. (2013). 
The generalized Gompertz distribution. Applied mathematical 
modelling, 37(1-2), 13-24.
}
\seealso{
\link{GGD}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
