% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CS2e.R
\name{CS2e}
\alias{CS2e}
\title{The Cosine Sine Exponential family}
\usage{
CS2e(mu.link = "log", sigma.link = "log", nu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a CS2e distribution in the \code{gamlss()} function.
}
\description{
The Cosine Sine Exponential family
}
\details{
The Cosine Sine Exponential distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)=\frac{\pi \sigma \mu \exp(\frac{-x} {\nu})}{2 \nu [(\mu\sin(\frac{\pi}{2} \exp(\frac{-x} {\nu})) + \sigma\cos(\frac{\pi}{2} \exp(\frac{-x} {\nu}))]^2}, }

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu 
y <- rCS2e(n=100, mu = 0.1, sigma =1, nu=0.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family='CS2e',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.45, max=0.55)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(0.2 - x1)
sigma <- exp(0.8 - x2)
nu <- 0.5
x <- rCS2e(n=n, mu, sigma, nu)

mod <- gamlss(x~x1, sigma.fo=~x2, nu.fo=~1,family=CS2e,
              control=gamlss.control(n.cyc=50000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
}
\references{
Chesneau, C., Bakouch, H. S., & Hussain, T. (2019). A new 
class of probability distributions via cosine and sine 
functions with applications. Communications in 
Statistics-Simulation and Computation, 48(8), 2287-2300.
}
\seealso{
\link{dCS2e}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
